/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static File createTemporaryFile(String prefix, String suffix) {
        String TMP_FILE_DIR = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(TMP_FILE_DIR);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new RuntimeException("Unable to create directory to store temporary files: " + tmpDir.getAbsolutePath());
        }
        try {
            return File.createTempFile(prefix, suffix, tmpDir);
        }
        catch (IOException e) {
            String msg = "Unable to create a temporary file in the directory: " + tmpDir.getAbsolutePath();
            LOG.error(msg);
            throw new RuntimeException(msg, e);
        }
    }

    public static boolean deleteFilesFromDirectoryWithName(final String regExPattern, File directory) {
        LOG.info("Attempting to delete files from directory: '" + directory.getAbsolutePath() + "' which match the pattern: '" + regExPattern + "'");
        File[] matchingFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regExPattern);
            }
        });
        if (matchingFiles.length == 0) {
            LOG.info("There are no files that match this specified pattern. Nothing to do.");
            return true;
        }
        LOG.info("There are " + matchingFiles.length + " files that match this criteria. Attempting to delete.");
        int remainingItems = matchingFiles.length;
        for (File aFile : matchingFiles) {
            if (!aFile.delete()) continue;
            --remainingItems;
        }
        if (remainingItems > 0) {
            LOG.warn("Unable to delete " + remainingItems + " files from the temporary directory.");
            return false;
        }
        LOG.info("All matching items in the directory deleted ");
        return true;
    }

    public static InputStream readFileAsStream(String filePath) {
        File f = new File(filePath);
        return FileUtil.readFileAsStream(f);
    }

    public static InputStream readFileAsStream(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Missing Argument 'File' to method readFileAsStream");
        }
        FileInputStream stream = null;
        try {
            if (!f.exists()) {
                throw new IllegalArgumentException("File not found : " + f.getAbsolutePath());
            }
            stream = new FileInputStream(f);
            return new BufferedInputStream(stream);
        }
        catch (Exception e) {
            if (stream != null) {
                StreamUtil.closeStream(stream);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public static OutputStream getOutputStream(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Missing Argument 'File' to method getOutputStream");
        }
        FileOutputStream stream = null;
        try {
            if (!f.exists()) {
                FileUtil.createFile(f);
            }
            stream = new FileOutputStream(f);
            return new BufferedOutputStream(stream);
        }
        catch (Exception e) {
            if (stream != null) {
                StreamUtil.closeStream(stream);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public static OutputStream getOutputStream(String filePath) {
        File f = new File(filePath);
        return FileUtil.getOutputStream(f);
    }

    public static byte[] readFileAsByteArray(File f) {
        byte[] byArray;
        if (!f.exists()) {
            throw new IllegalArgumentException("File '" + f.getAbsolutePath() + "' does not exist");
        }
        FileInputStream fis = null;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            fis = new FileInputStream(f);
            StreamUtil.copyStream(fis, bytes);
            byArray = bytes.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(fis);
                throw throwable;
            }
        }
        StreamUtil.closeStream(fis);
        return byArray;
    }

    public static byte[] readFileAsByteArray(String filePath) {
        File f = new File(filePath);
        return FileUtil.readFileAsByteArray(f);
    }

    public static String readFileAsString(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new IllegalArgumentException("File '" + filePath + "' does not exist");
        }
        BufferedReader br = null;
        try {
            String string;
            FileReader fr = new FileReader(f);
            try {
                String line;
                br = new BufferedReader(fr);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8), true);
                while ((line = br.readLine()) != null) {
                    pw.println(line);
                }
                pw.close();
                string = new String(out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            fr.close();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void readFile(String filePath, OutputStream out) {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new IllegalArgumentException("File '" + filePath + "' does not exist");
        }
        try {
            StreamUtil.copyStream(new FileInputStream(f), out);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean exists(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static boolean deleteFile(String filePath) {
        File f = new File(filePath);
        return f.delete();
    }

    public static void createDirectory(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            throw new IllegalArgumentException("Directory '" + dir + "' can not be created, it already exists as a file");
        }
    }

    public static File createFile(String fileStr) {
        File f = new File(fileStr);
        FileUtil.createFile(f);
        return f;
    }

    public static File createFile(File aFile) {
        boolean createdParentDirectories;
        if (aFile.exists()) {
            return aFile;
        }
        File parentDir = aFile.getParentFile();
        if (!parentDir.exists() && !(createdParentDirectories = parentDir.mkdirs())) {
            throw new IllegalStateException("Unable to create directory structure: " + parentDir.getAbsolutePath());
        }
        try {
            aFile.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create file: " + aFile.getAbsolutePath());
        }
        return aFile;
    }

    public static boolean deleteDirectory(String path) {
        return FileUtil.deleteDirectory(new File(path));
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static int countFiles(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            String[] list = f.list();
            if (list == null) {
                return 0;
            }
            return list.length;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static String[] getFileNames(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            return f.list();
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static File[] getFiles(String directory) {
        File f = new File(directory);
        if (f.isDirectory()) {
            return f.listFiles();
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static void deleteFilesOlderThen(String directory, Date deleteFilesOlderThen) {
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified >= deleteFilesOlderThen.getTime()) continue;
                currentFile.delete();
            }
            return;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static void deleteOldestFile(String directory) {
        long oldestFileTime = Long.MAX_VALUE;
        File oldestFile = null;
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified >= oldestFileTime) continue;
                oldestFileTime = lastModified;
                oldestFile = currentFile;
            }
            if (oldestFile != null) {
                oldestFile.delete();
            }
            return;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    public static File getNewestFile(String directory) {
        long newestFileTime = Long.MIN_VALUE;
        File newestFile = null;
        File f = new File(directory);
        if (f.isDirectory()) {
            File[] files;
            for (File currentFile : files = f.listFiles()) {
                long lastModified = currentFile.lastModified();
                if (lastModified <= newestFileTime) continue;
                newestFileTime = lastModified;
                newestFile = currentFile;
            }
            return newestFile;
        }
        throw new IllegalArgumentException(directory + " is not a directory");
    }

    private static InputStream obtainInputStream(File aFile) {
        long proposedAbortTime = System.currentTimeMillis() + 180000L;
        while (true) {
            try {
                return new FileInputStream(aFile);
            }
            catch (FileNotFoundException e) {
                if (!aFile.exists()) {
                    return null;
                }
                LOG.warn("Unable to access the file - it appears to be locked! File: " + aFile.getAbsolutePath());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= proposedAbortTime) continue;
                System.out.println("Due to timeout, aborting attempting to get a lock on file: " + aFile);
                return null;
            }
            break;
        }
    }

    private static long readFile(InputStream is) {
        int size = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] ba = new byte[1024];
        try {
            while (bis.read(ba) != -1) {
                size += ba.length;
            }
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to read input Stream: " + e);
            e.printStackTrace();
        }
        try {
            bis.close();
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to close BufferedInputStream: " + e);
            e.printStackTrace();
        }
        try {
            is.close();
        }
        catch (IOException e) {
            System.err.println("IO exception when trying to close InputStream: " + e);
            e.printStackTrace();
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitTillAvailableForWriting(File aFile) {
        InputStream is;
        if (!aFile.exists()) {
            return true;
        }
        long priorSize = -1L;
        try {
            is = FileUtil.obtainInputStream(aFile);
            try {
                if (is == null) {
                    boolean bl = false;
                    return bl;
                }
                priorSize = FileUtil.readFile(is);
                StreamUtil.closeStream(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                is = FileUtil.obtainInputStream(aFile);
                try {
                    if (is == null) {
                        boolean bl = true;
                        return bl;
                    }
                    long currentSize = FileUtil.readFile(is);
                    if (currentSize == priorSize) {
                        return true;
                    }
                    priorSize = currentSize;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static File ensureDirectoryExists(String directoryName) {
        File f = new File(directoryName);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new RuntimeException("The specified directory is a file not a directory! Specified value: '" + directoryName + "'");
            }
            if (!f.canWrite()) {
                throw new RuntimeException("The specified directory does not have read permission! Specified value: '" + directoryName + "'");
            }
        } else {
            boolean successfulCreate = f.mkdirs();
            if (!successfulCreate) {
                throw new RuntimeException("Unable to create directory: " + directoryName);
            }
        }
        return f;
    }

    public static long getFileSize(File aFile) {
        return FileUtil.size(aFile.toPath());
    }

    public static long size(Path path) {
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    System.out.println("skipped: " + file + " (" + exc + ")");
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        System.out.println("had trouble traversing: " + dir + " (" + exc + ")");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)"walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return size.get();
    }

    public static long getFileSize(URI aURI) {
        return FileUtil.getFileSize(URIUtil.getFile(aURI));
    }

    public static void copyAllFilesInDir(File srcDir, File targetDir) throws IOException {
        if (!srcDir.exists()) {
            return;
        }
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File aFile = files[i];
            File target = new File(targetDir, aFile.getName());
            if (aFile.isDirectory()) {
                target.mkdirs();
                FileUtil.copyAllFilesInDir(aFile, target);
                continue;
            }
            FileUtil.copyFile(aFile, target);
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        try (FileInputStream fis = new FileInputStream(sourceFile);
             FileOutputStream fos = new FileOutputStream(destFile);){
            FileChannel source = fis.getChannel();
            FileChannel destination = fos.getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
    }

    public static List<String> getAllLines(Path f, Charset charset) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return Files.readAllLines(f, charset);
    }
}

