/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;

public class FusionImage {
    private BufferedImage image;
    private String base64Str;

    public FusionImage(String base64Str) throws IOException {
        if (base64Str == null) {
            throw new RuntimeException("base 64 string cannot be null");
        }
        this.base64Str = base64Str;
        String imageData = this.getPureBase64String();
        byte[] imageBytes = Base64.getDecoder().decode(imageData.getBytes("UTF8"));
        String imageFormat = this.getImageFormat();
        String[] validImageTypes = FusionImage.validFileTypes();
        boolean supported = false;
        for (int i = 0; i < validImageTypes.length; ++i) {
            String currFormat = validImageTypes[i];
            if (!imageFormat.equals(currFormat)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new RuntimeException("Image is unsupported");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(imageBytes);
        this.image = ImageIO.read(stream);
    }

    public static String[] validFileTypes() {
        return ImageIO.getReaderFileSuffixes();
    }

    public int getImageHeight() {
        return this.image.getHeight();
    }

    public int getImageWidth() {
        return this.image.getWidth();
    }

    public String getMimeType() {
        return this.base64Str.split(",")[0];
    }

    public String getPureBase64String() {
        return this.base64Str.substring(this.base64Str.indexOf(",") + 1);
    }

    public String getImageFormat() {
        String splitMimeType = this.getMimeType().split("/")[1];
        String type = splitMimeType.split(";")[0];
        if (type.equals("x-icon")) {
            return "ico";
        }
        return type;
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public String getBase64String() {
        return this.base64Str;
    }

    public long getBase64Size() {
        byte[] imageBytes = this.base64Str.getBytes(StandardCharsets.UTF_8);
        return imageBytes.length;
    }

    public long getFileSize() throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.image, this.getImageFormat(), tmp);
        tmp.close();
        long contentLength = tmp.size();
        return contentLength;
    }
}

