/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.http;

import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.api.http.IRESTGET;
import io.sdmx.api.http.Request;
import io.sdmx.utils.core.collection.CollectionUtil;
import io.sdmx.utils.core.date.SdmxDateImpl;
import io.sdmx.utils.core.object.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class RESTGET
implements IRESTGET {
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private List<String> path = new ArrayList<String>();
    private Map<String, String> headers = Collections.emptyMap();

    public RESTGET(Request request, String pathEntry) {
        this(request.getPath(), pathEntry);
        if (request.getHeaders() != null) {
            this.headers = Collections.unmodifiableMap(request.getHeaders());
        }
        this.queryParameters = Collections.unmodifiableMap(request.getParameters());
    }

    public RESTGET(String url, String pathEntry) {
        if (pathEntry != null) {
            int dataIdx = url.indexOf(pathEntry);
            if (dataIdx < 0) {
                throw new SdmxSemmanticException("Can not build REST GET from URL  '" + url + "' - missing " + pathEntry + " path");
            }
            url = url.substring(dataIdx);
        }
        if (url != null) {
            String[] pathParamSplit = url.split("\\?", 2);
            String path = pathParamSplit[0];
            for (String currentPath : path.split("/")) {
                this.path.add(currentPath);
            }
            if (pathParamSplit.length > 1 && ObjectUtil.validString(pathParamSplit[1])) {
                String[] paramsSplit;
                String params = pathParamSplit[1];
                for (String currentParam : paramsSplit = params.split("&")) {
                    String[] cParamSplit = currentParam.split("=");
                    if (cParamSplit.length != 2) {
                        throw new SdmxSemmanticException("Malformed query parameter: " + currentParam);
                    }
                    this.queryParameters.put(cParamSplit[0], cParamSplit[1]);
                }
            }
        }
        this.queryParameters = Collections.unmodifiableMap(this.queryParameters);
        this.path = Collections.unmodifiableList(this.path);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getPathParameter(int idx) {
        return this.path.size() > idx ? this.path.get(idx) : null;
    }

    @Override
    public SdmxDate getSdmxDateParamValue(String param) {
        String val = this.getStringParamValue(param);
        if (val != null) {
            try {
                return new SdmxDateImpl(val);
            }
            catch (Throwable e) {
                throw new SdmxSemmanticException("Illegal value '" + val + "' for parameter '" + param + "' - expecting an SDMX compliant Date");
            }
        }
        return null;
    }

    @Override
    public Integer getIntegerParamValue(String param) {
        String val = this.getStringParamValue(param);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException("Illegal value '" + val + "' for parameter '" + param + "' - expecting an Integer");
            }
        }
        return null;
    }

    @Override
    public Boolean getBooleanParamValue(String param) {
        String val = this.getStringParamValue(param);
        if (val != null) {
            return Boolean.valueOf(val);
        }
        return null;
    }

    @Override
    public String getStringParamValue(String param) {
        if (param == null) {
            return null;
        }
        return this.queryParameters.get(param);
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    public String toString() {
        return this.toURL(new String[0]);
    }

    @Override
    public String toURL(String ... removeParams) {
        HashSet<String> ignoreParams = removeParams == null ? Collections.emptySet() : new HashSet<String>();
        for (String removeParam : removeParams) {
            ignoreParams.add(removeParam.toLowerCase());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CollectionUtil.collectionToString(this.path, "/", ""));
        if (this.queryParameters.size() > 0) {
            String concat = "?";
            TreeSet<String> keys = new TreeSet<String>(this.queryParameters.keySet());
            for (String param : keys) {
                if (ignoreParams.contains(param)) continue;
                String paramValue = this.queryParameters.get(param);
                sb.append(concat + param + "=" + paramValue);
                concat = "&";
            }
        }
        return sb.toString();
    }
}

