/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.http;

import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.thread.ThreadLocalUtil;
import org.springframework.util.Base64Utils;

public class AuthorizationUtil {
    public static String createAuthorizationHeader(String username, String password) {
        String source = username + ":" + password;
        String ret = "Basic " + Base64Utils.encodeToString(source.getBytes());
        return ret;
    }

    public static void storeAuthorizationInThreadLocal(String username, String password) {
        ThreadLocalUtil.storeOnThread("Authorization", AuthorizationUtil.createAuthorizationHeader(username, password));
    }

    public static void storeCertificateAuthorizationInThreadLocal(byte[] certiciate, String password) {
        ThreadLocalUtil.storeOnThread("P12Certificate", certiciate);
        ThreadLocalUtil.storeOnThread("P12CertificatePassword", password);
    }

    public static void storeAuthorizationInThreadLocal(String username, String password, String forwardedFor) {
        AuthorizationUtil.storeAuthorizationInThreadLocal(username, password);
        if (ObjectUtil.validString(forwardedFor)) {
            ThreadLocalUtil.storeOnThread("X-Forwarded-For", forwardedFor);
        }
    }

    public static void clearAuthorizationFromThreadLocal() {
        ThreadLocalUtil.clearFromThread("P12Certificate");
        ThreadLocalUtil.clearFromThread("P12CertificatePassword");
        ThreadLocalUtil.clearFromThread("Authorization");
        ThreadLocalUtil.clearFromThread("X-Forwarded-For");
    }
}

