/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.format;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.http.IVNDHeader;
import io.sdmx.utils.core.object.ObjectUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VNDHeader
implements IVNDHeader {
    private static final String VND_HEADER = "application/vnd.";
    private String applicationVnd;
    private String vnd;
    private Map<String, String> parameters = new HashMap<String, String>();

    public VNDHeader(String applicationVnd) {
        if (!ObjectUtil.validString(applicationVnd)) {
            throw new SdmxException("VNDHEader can not be created with empty argument");
        }
        this.applicationVnd = applicationVnd;
        if (applicationVnd.startsWith(VND_HEADER)) {
            applicationVnd = applicationVnd.substring(VND_HEADER.length());
        }
        String[] split = applicationVnd.split(";");
        this.vnd = split[0];
        for (String currentSplit : split) {
            String[] vals = currentSplit.split("=");
            if (vals.length != 2) continue;
            if (vals[0] != null) {
                vals[0] = vals[0].trim();
            }
            this.parameters.put(vals[0], vals[1]);
        }
        Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getOriginalVND() {
        return this.applicationVnd;
    }

    @Override
    public boolean hasParameter(String parameter) {
        return this.parameters.containsKey(parameter);
    }

    @Override
    public String getParameterValue(String parameter) {
        return this.parameters.get(parameter);
    }

    @Override
    public String getVnd() {
        return this.vnd;
    }
}

