/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.format;

import io.sdmx.api.format.FormatDetails;
import io.sdmx.api.http.MIME_TYPE;
import io.sdmx.utils.core.object.AssertUtil;

public class FormatDetailsImpl
implements FormatDetails {
    private String asString;
    private String fileExtension;
    private String mimeType;
    private String[] vndHeader;
    private boolean isVaryAcceptLanguage;
    private boolean isSaveOnly;

    public FormatDetailsImpl(String asString, MIME_TYPE mimeType, boolean isVaryAcceptLanguage, String ... vndHeader) {
        this(asString, mimeType, isVaryAcceptLanguage, false, vndHeader);
    }

    public FormatDetailsImpl(String asString, String fileExtension, String mimeType, boolean isVaryAcceptLanguage, String ... vndHeader) {
        this(asString, fileExtension, mimeType, isVaryAcceptLanguage, false, vndHeader);
    }

    public FormatDetailsImpl(String asString, MIME_TYPE mimeType, boolean isVaryAcceptLanguage, boolean isSaveOnly, String ... vndHeader) {
        this(asString, mimeType.getFileExtension(), mimeType.getMimeType(), isVaryAcceptLanguage, false, vndHeader);
    }

    public FormatDetailsImpl(String asString, String fileExtension, String mimeType, boolean isVaryAcceptLanguage, boolean isSaveOnly, String ... vndHeader) {
        AssertUtil.notEmpty(asString, "asString");
        AssertUtil.notEmpty(fileExtension, "fileExtension");
        AssertUtil.notEmpty(mimeType, "mimeType");
        this.asString = asString;
        this.fileExtension = fileExtension;
        this.mimeType = mimeType;
        this.isVaryAcceptLanguage = isVaryAcceptLanguage;
        this.vndHeader = vndHeader;
        this.isSaveOnly = isSaveOnly;
    }

    @Override
    public boolean isVaryWithAcceptLanguage() {
        return this.isVaryAcceptLanguage;
    }

    @Override
    public String[] getAcceptHeaders() {
        return this.vndHeader;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getFormatAsString() {
        return this.asString;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public boolean isSaveOnly() {
        return this.isSaveOnly;
    }
}

