/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.file;

import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.api.io.WriteableDataLocation;
import io.sdmx.utils.core.io.MutlipleReadableDataLocation;
import io.sdmx.utils.core.io.OverflowWriteableDataLocation;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.random.RandomUtil;
import io.sdmx.utils.core.xlsx.XLSXUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final byte[] ZIP_BEGIN_BYTES = new byte[]{80, 75, 3, 4};

    public static List<String> getZipFileNames(URI inFile) {
        ArrayList<String> returnList = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(inFile.toString());){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String fileName = zipEntries.nextElement().getName();
                returnList.add(fileName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return returnList;
    }

    public static List<String> getZipFileNames(InputStream inS) throws IOException {
        ArrayList<String> returnList = new ArrayList<String>();
        try (ZipInputStream in = new ZipInputStream(inS);){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                String entryName = entry.getName();
                returnList.add(entryName);
            }
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    public static boolean getFileFromZip(URI inFile, String fileName, OutputStream out) {
        return ZipUtil.getFileFromZip(URIUtil.getInputStream(inFile), fileName, out);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getFileFromZip(InputStream is, String fileName, OutputStream out) {
        block7: {
            in = null;
            try {
                in = new ZipInputStream(is);
                entry = null;
                while ((entry = in.getNextEntry()) != null) {
                    entryName = entry.getName();
                    if (!entryName.equals(fileName)) continue;
                    buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    var8_10 = true;
                    break block7;
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable var9_11) {
                    StreamUtil.closeStream(new InputStream[]{in});
                    StreamUtil.closeStream(new InputStream[]{is});
                    StreamUtil.closeStream(new OutputStream[]{out});
                    throw var9_11;
                }
            }
        }
        StreamUtil.closeStream(new InputStream[]{in});
        StreamUtil.closeStream(new InputStream[]{is});
        StreamUtil.closeStream(new OutputStream[]{out});
        return var8_10;
lbl-1000:
        // 1 sources

        {
            var5_7 = false;
        }
        StreamUtil.closeStream(new InputStream[]{in});
        StreamUtil.closeStream(new InputStream[]{is});
        StreamUtil.closeStream(new OutputStream[]{out});
        return var5_7;
    }

    public static Map<String, ByteArrayOutputStream> upzipFiles(URI zipFileLoction) {
        HashMap<String, ByteArrayOutputStream> hashMap;
        HashMap<String, ByteArrayOutputStream> inputStreamMap = new HashMap<String, ByteArrayOutputStream>();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(URIUtil.getInputStream(zipFileLoction));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                inputStreamMap.put(entryName, out);
                out = null;
            }
            hashMap = inputStreamMap;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        return hashMap;
    }

    public static void upzipFiles(URI zipFileLoction, File unpackDirectory) {
        if (unpackDirectory.isFile()) {
            throw new IllegalArgumentException(unpackDirectory + " is not a directory");
        }
        if (!unpackDirectory.exists()) {
            unpackDirectory.mkdirs();
        }
        ZipInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new ZipInputStream(URIUtil.getInputStream(zipFileLoction));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                File f = new File(unpackDirectory + "/" + entryName);
                f.createNewFile();
                FileOutputStream fOut = new FileOutputStream(f);
                out = new BufferedOutputStream(fOut);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                StreamUtil.closeStream(out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        StreamUtil.closeStream(out);
    }

    public static boolean isAZip(byte[] data) {
        if (data == null || data.length < ZIP_BEGIN_BYTES.length) {
            return false;
        }
        for (int i = 0; i < ZIP_BEGIN_BYTES.length; ++i) {
            if (data[i] == ZIP_BEGIN_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAZip(ReadableDataLocation dataLocation) {
        if (dataLocation == null) {
            return false;
        }
        if (dataLocation instanceof MutlipleReadableDataLocation) {
            return true;
        }
        InputStream in = dataLocation.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(in);
        byte[] byteArray = new byte[4];
        try {
            bis.read(byteArray, 0, 4);
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
            StreamUtil.closeStream(in);
            return bl;
        }
        StreamUtil.closeStream(in);
        boolean isZip = ZipUtil.isAZip(byteArray);
        boolean isExcel = XLSXUtil.isXlsx(dataLocation);
        return isZip && !isExcel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(Map<String, URI> topZip, URI outFile) {
        URI uRI = outFile;
        synchronized (uRI) {
            byte[] buf = new byte[1024];
            try {
                ZipOutputStream out = new ZipOutputStream(URIUtil.getOutputStream(outFile));
                for (String currentInputFileName : topZip.keySet()) {
                    int len;
                    URI zipURI = topZip.get(currentInputFileName);
                    if (zipURI == null) continue;
                    buf = new byte[1024];
                    InputStream in = URIUtil.getInputStream(zipURI);
                    out.putNextEntry(new ZipEntry(currentInputFileName));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void zipFile(ReadableDataLocation inFile, WriteableDataLocation outFile) {
        ZipUtil.zipFile(inFile.getInputStream(), inFile.getName(), outFile);
    }

    public static void zipFile(WriteableDataLocation outFile, ReadableDataLocation ... inFiles) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(outFile.getOutputStream());
            for (ReadableDataLocation rdl : inFiles) {
                int len;
                String zipEntryName = rdl.getName();
                if (!ObjectUtil.validString(zipEntryName)) {
                    zipEntryName = RandomUtil.generateRandomString();
                }
                out.putNextEntry(new ZipEntry(zipEntryName));
                InputStream in = rdl.getInputStream();
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFile(InputStream in, String zipEntryName, WriteableDataLocation outFile) {
        ZipUtil.zipFile(in, zipEntryName, outFile.getOutputStream());
    }

    public static void zipFile(InputStream in, String zipEntryName, OutputStream outFile) {
        byte[] buf = new byte[1024];
        try {
            int len;
            ZipOutputStream out = new ZipOutputStream(outFile);
            if (!ObjectUtil.validString(zipEntryName)) {
                zipEntryName = RandomUtil.generateRandomString();
            }
            out.putNextEntry(new ZipEntry(zipEntryName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addFilesToExistingZip(File zipFile, File f) throws IOException {
        ZipUtil.addFilesToExistingZip(zipFile, f.getName(), new FileInputStream(f));
    }

    public static void addFilesToExistingZip(File zipFile, String toAddName, InputStream toAdd) throws IOException {
        int len;
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            if (toAddName.equals(name)) {
                notInFiles = false;
                break;
            }
            if (notInFiles) {
                int len2;
                out.putNextEntry(new ZipEntry(name));
                while ((len2 = zin.read(buf)) > 0) {
                    out.write(buf, 0, len2);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        out.putNextEntry(new ZipEntry(toAddName));
        while ((len = toAdd.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        toAdd.close();
        out.close();
        tempFile.delete();
    }

    public static List<ReadableDataLocation> unzipFiles(ReadableDataLocation dataLocation) {
        if (dataLocation instanceof MutlipleReadableDataLocation) {
            return ((MutlipleReadableDataLocation)dataLocation).getItems();
        }
        int fileCount = ZipUtil.getCountOfFiles(dataLocation);
        if (fileCount < 1) {
            throw new IllegalArgumentException("Can not unzip file - either supplied file is not a zip file, or file is corrupt");
        }
        ArrayList<ReadableDataLocation> returnLocations = new ArrayList<ReadableDataLocation>();
        ZipInputStream in = new ZipInputStream(dataLocation.getInputStream());
        ZipEntry zipEntry = null;
        OutputStream out = null;
        try {
            while ((zipEntry = in.getNextEntry()) != null) {
                int len;
                OverflowWriteableDataLocation dataLocationOut = new OverflowWriteableDataLocation(zipEntry.getName());
                out = dataLocationOut.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                returnLocations.add(dataLocationOut);
            }
            in.close();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(out);
        return returnLocations;
    }

    public static ReadableDataLocation unzipFile(ReadableDataLocation dataLocation) {
        int fileCount = ZipUtil.getCountOfFiles(dataLocation);
        if (fileCount < 1) {
            throw new IllegalArgumentException("Can not unzip file - either supplied file is not a zip file, or file is corrupt");
        }
        if (fileCount > 1) {
            throw new IllegalArgumentException("Can not unzip file, expecting only one file in zip contents, got " + fileCount);
        }
        OverflowWriteableDataLocation dataLocationOut = new OverflowWriteableDataLocation();
        ZipUtil.unzipFile(dataLocation, dataLocationOut.getOutputStream());
        return dataLocationOut;
    }

    public static void unzipFile(ReadableDataLocation dataLocation, OutputStream out) {
        try {
            int len;
            ZipInputStream in = new ZipInputStream(dataLocation.getInputStream());
            in.getNextEntry();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzipFiles(ReadableDataLocation dataLocation, OutputStream out) {
        try {
            int len;
            ZipInputStream in = new ZipInputStream(dataLocation.getInputStream());
            in.getNextEntry();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getZipFileNames(ReadableDataLocation rdl) {
        ArrayList<String> arrayList;
        ArrayList<String> returnList = new ArrayList<String>();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(rdl.getInputStream());
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                String entryName = entry.getName();
                returnList.add(entryName);
            }
            arrayList = returnList;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFileIntoDirectory(ZipFile zipFile, File unzipDir) {
        Enumeration<? extends ZipEntry> files = zipFile.entries();
        FileOutputStream fos = null;
        while (files.hasMoreElements()) {
            try {
                ZipEntry entry = files.nextElement();
                InputStream eis = zipFile.getInputStream(entry);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                File f = new File(unzipDir.getAbsolutePath() + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                f.createNewFile();
                fos = new FileOutputStream(f);
                while ((bytesRead = eis.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getCountOfFiles(ReadableDataLocation rdl) {
        int count = 0;
        try (ZipInputStream in = new ZipInputStream(rdl.getInputStream());){
            while (in.getNextEntry() != null) {
                ++count;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return count;
    }
}

