/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.file;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import io.sdmx.api.csv.DELIMITER;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.ZipUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.StringUtil;
import io.sdmx.utils.core.xlsx.XLSXUtil;
import io.sdmx.utils.core.xml.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FormatUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FILE_FORMAT determineFileFormat(ReadableDataLocation rdl) {
        if (rdl == null) {
            return null;
        }
        if (ZipUtil.isAZip(rdl)) {
            return FILE_FORMAT.ZIP;
        }
        if (XLSXUtil.isXlsx(rdl)) {
            return FILE_FORMAT.XLSX;
        }
        String fileName = rdl.getName();
        if (XmlUtils.isXML(rdl)) {
            return FILE_FORMAT.XML;
        }
        boolean wasAlreadyDisabled = SdmxException.isDisabledExceptionTrace();
        String firstXChars = null;
        InputStream stream = null;
        try {
            stream = rdl.getInputStream();
            firstXChars = new String(StreamUtil.readFirstXBytes(stream, 100));
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(stream);
            if (!wasAlreadyDisabled) {
                SdmxException.disableExceptionTrace(false);
            }
            throw throwable;
        }
        StreamUtil.closeStream(stream);
        if (!wasAlreadyDisabled) {
            SdmxException.disableExceptionTrace(false);
        }
        if (FormatUtil.isEDI(firstXChars = StringUtil.trim(firstXChars).toUpperCase())) {
            return FILE_FORMAT.EDI;
        }
        if (FormatUtil.isJson(firstXChars)) {
            return FILE_FORMAT.JSON;
        }
        if (FormatUtil.isHtml(firstXChars)) {
            return FILE_FORMAT.HTML;
        }
        if (FormatUtil.isCSV(rdl)) {
            return FILE_FORMAT.CSV;
        }
        return FILE_FORMAT.TEXT;
    }

    public static boolean isCSV(ReadableDataLocation rdl) {
        return FormatUtil.getCSVDelimiter(rdl) != null;
    }

    public static DELIMITER getCSVDelimiter(ReadableDataLocation rdl) {
        for (DELIMITER currentDelimiter : DELIMITER.values()) {
            try {
                if (!FormatUtil.isSameSplitSize(rdl.getInputStream(), currentDelimiter.getDelimiter())) continue;
                return currentDelimiter;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSameSplitSize(InputStream is, char separator) {
        int row;
        InputStreamReader streamReader = new InputStreamReader(is);
        int size = -1;
        CSVParser parser = new CSVParserBuilder().withSeparator(separator).build();
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)streamReader).withCSVParser((ICSVParser)parser).build();){
            String[] nextLine;
            for (row = 0; row < 3 && (nextLine = csvReader.readNext()) != null; ++row) {
                int rowSize = nextLine.length;
                if (size == -1) {
                    size = rowSize;
                }
                if (rowSize == size) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (CsvValidationException | IOException e) {
            StreamUtil.closeStream(is);
        }
        if (row < 2) {
            return false;
        }
        if (size <= 1) return false;
        return true;
    }

    private static boolean isHtml(String firstXChars) {
        return firstXChars.contains("<HTML") || firstXChars.contains("<!DOCTYPE HTML");
    }

    private static boolean isEDI(String firstXChars) {
        return firstXChars.startsWith("UNA");
    }

    public static boolean isJson(String firstXChars) {
        return firstXChars.startsWith("[") || firstXChars.startsWith("{") && firstXChars.contains(":");
    }
}

