/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.expression;

import io.sdmx.api.chars.CHARS;
import java.util.ArrayList;
import java.util.List;

public class Exp {
    private static final char START_PARANTHESIS = "(".toCharArray()[0];
    private static final char END_PARANTHESIS = ")".toCharArray()[0];
    private List<String> blocks = new ArrayList<String>(5);
    private List<Integer> blockLevel = new ArrayList<Integer>(3);
    private List<Integer> charIdx = new ArrayList<Integer>();
    private char startBlockCopy;
    private char endBlockCopy;
    private boolean trim = false;
    private char escape = "\\".charAt(0);
    private char[] breakOn;
    private boolean supportLevels = true;
    private String expression;

    private Exp(char ... breakChars) {
        this.breakOn = breakChars;
    }

    public static Exp get(char ... breakChars) {
        return new Exp(breakChars);
    }

    public static Exp build(CHARS ... breakChars) {
        return new Exp(CHARS.toCharArray(breakChars));
    }

    public Exp blockCopy(CHARS start, CHARS end) {
        return this.blockCopy(start.getChar(), end.getChar());
    }

    public Exp blockCopy(char start, char end) {
        this.startBlockCopy = start;
        this.endBlockCopy = end;
        return this;
    }

    public Exp escape(char escapeChar) {
        this.escape = escapeChar;
        return this;
    }

    public Exp trim() {
        this.trim = true;
        return this;
    }

    public Exp setSupportLevels(boolean supportLevels) {
        this.supportLevels = supportLevels;
        return this;
    }

    public Exp parse(String expression) {
        this.expression = expression;
        if (expression == null) {
            return this;
        }
        if (expression.length() == 0) {
            this.addBlock("", 1, 0);
            return this;
        }
        StringBuilder sb = null;
        int level = 1;
        boolean escape = false;
        int inCopyBlock = -1;
        int charIdx = -1;
        block0: for (char c : expression.toCharArray()) {
            ++charIdx;
            if (c == this.endBlockCopy && !escape && --inCopyBlock < 0) {
                this.addBlock(sb, 0, charIdx);
                sb = null;
                continue;
            }
            if (inCopyBlock >= 0) {
                if (c == this.startBlockCopy) {
                    ++inCopyBlock;
                }
                sb.append(c);
                continue;
            }
            if (c == this.startBlockCopy) {
                ++inCopyBlock;
                if (sb != null && sb.length() != 0) {
                    this.addBlock(sb, level, charIdx - 1);
                }
                sb = new StringBuilder();
                continue;
            }
            if (this.supportLevels && c == START_PARANTHESIS) {
                this.addBlock("(", level * -1, charIdx);
                ++level;
                if (sb != null && sb.length() != 0) {
                    this.addBlock(sb, level, charIdx - 1);
                }
                sb = new StringBuilder();
                continue;
            }
            if (this.supportLevels && c == END_PARANTHESIS) {
                if (sb != null && sb.length() != 0) {
                    this.addBlock(sb, level, charIdx - 1);
                    sb = null;
                }
                if (level > 1) {
                    --level;
                }
                this.addBlock(")", level * -1, charIdx);
                continue;
            }
            if (c == this.escape) {
                escape = true;
                continue;
            }
            if (!escape && this.breakOn != null) {
                for (char breakChar : this.breakOn) {
                    if (c != breakChar) continue;
                    if (sb != null && sb.length() != 0) {
                        this.addBlock(sb, level, charIdx - 1);
                        sb = new StringBuilder();
                    }
                    this.addBlock(new String(new char[]{breakChar}), level * -1, charIdx);
                    continue block0;
                }
            }
            escape = false;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(c);
        }
        this.addBlock(sb, level, charIdx);
        return this;
    }

    public String substring(int startBlock) {
        if (startBlock == 0) {
            return this.expression;
        }
        return this.expression.substring(this.getCharIdx(startBlock - 1) + 1);
    }

    public String substring(int startBlock, int endBlock) {
        int startIndex = startBlock == 0 ? 0 : this.getCharIdx(startBlock - 1) + 1;
        return this.expression.substring(startIndex, this.getCharIdx(endBlock) + 1);
    }

    private void addBlock(StringBuilder sb, int poistion, int toCharIdx) {
        if (sb != null) {
            String str = sb.toString();
            if (this.trim) {
                str = str.trim();
            }
            this.addBlock(str, poistion, toCharIdx);
        }
    }

    private void addBlock(String string, int poistion, int toCharIdx) {
        if (string != null) {
            this.blocks.add(string);
            this.blockLevel.add(poistion);
            this.charIdx.add(toCharIdx);
        }
    }

    public int size() {
        return this.blocks.size();
    }

    public String getBlock(int pos) {
        return this.blocks.get(pos);
    }

    public Integer getLevel(int pos) {
        return this.blockLevel.get(pos);
    }

    public Integer getCharIdx(int pos) {
        return this.charIdx.get(pos);
    }
}

