/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.error;

import io.sdmx.utils.core.io.SerializeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ErrorReport
implements Serializable {
    private static final long serialVersionUID = -5874227775868948616L;
    private Integer id;
    private String errorType;
    private List<byte[]> errorMessagesAsByteArray = new ArrayList<byte[]>();
    private ArrayList<String> errorMessage = new ArrayList();
    private static final int CHUNK_SIZE = 1024;
    private Throwable th;

    public ErrorReport() {
    }

    private ErrorReport(Throwable e) {
        this.addErrorMessage(e);
        this.th = e;
        this.errorMessagesAsByteArray = SerializeUtil.serializeAsChunkedByteArray(this.errorMessage, 1024, false);
    }

    private ErrorReport(String msg) {
        this.addErrorMessage(msg);
        this.errorMessagesAsByteArray = SerializeUtil.serializeAsChunkedByteArray(this.errorMessage, 1024, false);
    }

    private ErrorReport(String msg, Throwable e) {
        this.addErrorMessage(msg, e);
        this.th = e;
        Collections.reverse(this.errorMessage);
        this.errorMessagesAsByteArray = SerializeUtil.serializeAsChunkedByteArray(this.errorMessage, 1024, false);
    }

    public Throwable getThrowable() {
        return this.th;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    private void addErrorMessage(Throwable e) {
        if (e != null) {
            String errorMessageStr = e.getMessage();
            if (errorMessageStr == null) {
                this.errorMessage.add("Null Pointer");
            } else {
                for (String currentError : errorMessageStr.split(System.getProperty("line.separator"))) {
                    this.errorMessage.add(currentError);
                }
            }
            this.addErrorMessage(e.getCause());
        }
    }

    private void addErrorMessage(String msg) {
        this.errorMessage.add(msg);
    }

    private void addErrorMessage(String msg, Throwable e) {
        if (e != null) {
            this.errorMessage.add(msg + ": " + e.getMessage());
            this.addErrorMessage(e.getCause());
        }
    }

    public static ErrorReport build(Throwable e) {
        ErrorReport report = new ErrorReport(e);
        return report;
    }

    public static ErrorReport build(String msg) {
        ErrorReport report = new ErrorReport(msg);
        return report;
    }

    public static ErrorReport build(List<String> msg) {
        ErrorReport report = new ErrorReport();
        for (String currentMsg : msg) {
            report.addErrorMessage(currentMsg);
        }
        return report;
    }

    public static ErrorReport build(String msg, Throwable e) {
        ErrorReport report = new ErrorReport(msg, e);
        return report;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public List<String> getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(List<String> errorMessage) {
    }

    public List<byte[]> getSerializedErrorMessage() {
        return this.errorMessagesAsByteArray;
    }

    public void setSerializedErrorMessage(List<byte[]> ba) {
        this.errorMessagesAsByteArray = ba;
        if (this.errorMessagesAsByteArray.size() > 0) {
            this.errorMessage = (ArrayList)SerializeUtil.deSerializeChunkedByteArray(ba);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.errorMessage.size(); ++i) {
            if (i > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(this.errorMessage.get(i));
        }
        return sb.toString();
    }

    public String getStringForHtml() {
        StringBuilder sb = new StringBuilder();
        for (String currentMessage : this.errorMessage) {
            sb.append("Caused By " + currentMessage);
        }
        return sb.toString();
    }
}

