/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.date;

import io.sdmx.api.date.ITimePeriod;
import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.date.TIME_FORMAT;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.utils.core.date.DateUtil;
import io.sdmx.utils.core.date.SdmxDateImpl;
import io.sdmx.utils.core.object.NumberUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimePeriod
implements ITimePeriod {
    private static final Pattern CAST_DATE_PATTERN;
    private Map<String, SdmxDate> expressionToISOTime = new HashMap<String, SdmxDate>();
    private SdmxDate basePeriod;
    private SdmxDate basePeriodEndOfPeriod;
    private static char P;
    private static char PLUS;
    private static char MINUS;

    public TimePeriod(SdmxDate basePeriod) {
        if (basePeriod == null) {
            throw new SdmxException("TimePeriod.basePeriod can not be null");
        }
        this.basePeriod = basePeriod;
        this.basePeriodEndOfPeriod = new SdmxDateImpl(basePeriod.getDateInSdmxFormat(), false);
    }

    @Override
    public SdmxDate getBasePeriod() {
        return this.basePeriod;
    }

    @Override
    public boolean isExpression(String expression) {
        return TimePeriod.isExpresion(expression);
    }

    public static boolean isExpresion(String expression) {
        char[] chars = expression.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        if (chars[0] == P) {
            if (chars.length == 1) {
                return true;
            }
            if (chars.length == 2) {
                return false;
            }
            if (chars[1] != PLUS && chars[1] != MINUS) {
                return false;
            }
            for (int i = 2; i < chars.length; ++i) {
                if (NumberUtils.isNumber(chars[i])) continue;
                return false;
            }
            return true;
        }
        Matcher m = CAST_DATE_PATTERN.matcher(expression);
        return m.find();
    }

    @Override
    public SdmxDate getTimePeriod(String expression) {
        SdmxDate isoTime = this.expressionToISOTime.get(expression);
        if (isoTime == null) {
            isoTime = this.executeTimePeriodExpresion(expression);
            this.expressionToISOTime.put(expression, isoTime);
        }
        return isoTime;
    }

    private SdmxDate executeTimePeriodExpresion(String expression) {
        if (expression.startsWith("P")) {
            return this.processPeriodFunction(expression);
        }
        Matcher m = CAST_DATE_PATTERN.matcher(expression);
        if (m.matches()) {
            SdmxDateImpl endOfPeriodDate;
            int moveNPeriods;
            boolean enclosingPeriodRule = expression.startsWith("F");
            TIME_FORMAT castFreq = TIME_FORMAT.getTimeFormatFromCodeId(m.group(1));
            String moveBasePeriod = m.group(2);
            String moveTargetPeriod = m.group(3);
            SdmxDate basePeriod = castFreq.getPeriodsInAYear() > this.basePeriod.getTimeFormatOfDate().getPeriodsInAYear() ? this.basePeriodEndOfPeriod : this.basePeriod;
            SdmxDate movedBasePeriod = moveBasePeriod == null ? basePeriod : this.moveNPeriods(basePeriod, moveBasePeriod);
            String cast = DateUtil.formatDate(movedBasePeriod.getDate(), castFreq);
            SdmxDateImpl basePeriodCast = new SdmxDateImpl(cast, false);
            int n = moveNPeriods = moveTargetPeriod == null ? 0 : this.moveNPeriods(moveTargetPeriod);
            if (enclosingPeriodRule && !(endOfPeriodDate = new SdmxDateImpl(movedBasePeriod.getDateInSdmxFormat(), false)).getDate().equals(basePeriodCast.getDate())) {
                --moveNPeriods;
            }
            if (moveNPeriods != 0) {
                return this.moveNPeriods((SdmxDate)basePeriodCast, moveNPeriods);
            }
            return basePeriodCast;
        }
        if (!DateUtil.isSdmxDate(expression)) {
            throw new SdmxSemmanticException("Unsupported date expression: " + expression);
        }
        return new SdmxDateImpl(expression);
    }

    private SdmxDate processPeriodFunction(String period) {
        if (period.length() == 1) {
            return this.basePeriod;
        }
        return this.moveNPeriods(this.basePeriod, period.substring(1));
    }

    private SdmxDate moveNPeriods(SdmxDate date, String expression) {
        return this.moveNPeriods(date, this.moveNPeriods(expression));
    }

    private SdmxDate moveNPeriods(SdmxDate date, int numPeriods) {
        return new SdmxDateImpl(DateUtil.movePeriod(date, numPeriods), false);
    }

    private int moveNPeriods(String expression) {
        boolean forwards = true;
        if (expression.startsWith("-")) {
            forwards = false;
        } else if (!expression.startsWith("+")) {
            throw new SdmxSemmanticException("Unexpected expresion for moving time periods: " + expression);
        }
        try {
            int numPeriods = Integer.parseInt(expression.substring(1));
            if (!forwards) {
                numPeriods *= -1;
            }
            return numPeriods;
        }
        catch (NumberFormatException ex) {
            throw new SdmxSemmanticException("Unexpected expresion for moving time periods: " + expression);
        }
    }

    static {
        P = "P".charAt(0);
        PLUS = "+".charAt(0);
        MINUS = "-".charAt(0);
        StringBuilder freqSb = new StringBuilder("[F]?");
        String concat = "(";
        for (TIME_FORMAT tf : TIME_FORMAT.values()) {
            freqSb.append(concat + tf.getFrequencyCodeId());
            concat = "|";
        }
        freqSb.append(")");
        freqSb.append("\\(P([(\\+\\-)]\\d+)?\\)([(\\+\\-)]\\d+)?");
        CAST_DATE_PATTERN = Pattern.compile(freqSb.toString());
    }
}

