/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.date;

import io.sdmx.api.date.PERIOD_OVERLAP;
import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.date.SdmxPeriod;
import io.sdmx.api.date.TIME_FORMAT;
import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.utils.core.date.SdmxDateImpl;
import io.sdmx.utils.core.object.ObjectUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class SdmxPeriodImpl
implements SdmxPeriod {
    private static final long serialVersionUID = 1L;
    private SdmxDate startPeriod;
    private SdmxDate endPeriod;
    private boolean isAllPeriods = false;
    public static final SdmxPeriod ALL_PERIODS = new SdmxPeriodImpl();

    private SdmxPeriodImpl() {
        this.isAllPeriods = true;
    }

    public SdmxPeriodImpl(String startPeriod, String endPeriod) {
        if (ObjectUtil.validString(startPeriod)) {
            this.startPeriod = new SdmxDateImpl(startPeriod);
        }
        if (ObjectUtil.validString(endPeriod)) {
            this.endPeriod = new SdmxDateImpl(endPeriod, false);
        }
        this.validate();
    }

    public SdmxPeriodImpl(Date startPeriod, Date endPeriod, TIME_FORMAT tf) {
        if (startPeriod != null) {
            this.startPeriod = new SdmxDateImpl(startPeriod, tf, true);
        }
        if (endPeriod != null) {
            this.endPeriod = new SdmxDateImpl(endPeriod, tf, false);
        }
        this.validate();
    }

    public SdmxPeriodImpl(SdmxDate startPeriod, SdmxDate endPeriod) {
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
        this.validate();
    }

    private void validate() {
        if (this.startPeriod == null && this.endPeriod == null) {
            throw new SdmxException("Can not create SdmxPeriod - no startPeriod or endPeriod defined");
        }
        if (this.startPeriod != null && this.endPeriod != null && this.startPeriod.isLater(this.endPeriod)) {
            throw new SdmxSemmanticException(ExceptionCode.END_DATE_BEFORE_START_DATE, new Object[0]);
        }
    }

    @Override
    public boolean isAllPeriods() {
        return this.isAllPeriods;
    }

    @Override
    public SdmxDate getStartPeriod() {
        return this.startPeriod;
    }

    @Override
    public SdmxDate getEndPeriod() {
        return this.endPeriod;
    }

    @Override
    public PERIOD_OVERLAP getOverlap(SdmxPeriod that) {
        if (this.equals(that)) {
            return PERIOD_OVERLAP.EXACT_MATCH;
        }
        if (this.isAllPeriods) {
            return PERIOD_OVERLAP.SUPERSET;
        }
        if (that == ALL_PERIODS) {
            return PERIOD_OVERLAP.SUBSET;
        }
        if (this.isStartEqual(that) && this.isEndEqual(that)) {
            return PERIOD_OVERLAP.EXACT_MATCH;
        }
        if (!this.isInPeriod(that)) {
            return PERIOD_OVERLAP.NOT_IN_PERIOD;
        }
        if (this.isFullyInPeriod(that)) {
            return PERIOD_OVERLAP.SUPERSET;
        }
        if (that.isFullyInPeriod(this)) {
            return PERIOD_OVERLAP.SUBSET;
        }
        return PERIOD_OVERLAP.OVERLAP;
    }

    @Override
    public Set<SdmxPeriod> split(SdmxPeriod that) {
        TIME_FORMAT thatTf;
        HashSet<SdmxPeriod> periods = new HashSet<SdmxPeriod>();
        if (that == null) {
            periods.add(this);
            return periods;
        }
        TIME_FORMAT tf = null;
        if (this.hasStartPeriod()) {
            tf = this.getStartPeriod().getTimeFormatOfDate();
        }
        if (this.hasEndPeriod()) {
            thatTf = this.getEndPeriod().getTimeFormatOfDate();
            if (tf == null) {
                tf = thatTf;
            } else if (thatTf.getPeriodsInAYear() > tf.getPeriodsInAYear()) {
                tf = thatTf;
            }
        }
        if (that.hasStartPeriod()) {
            thatTf = that.getStartPeriod().getTimeFormatOfDate();
            if (tf == null) {
                tf = thatTf;
            } else if (thatTf.getPeriodsInAYear() > tf.getPeriodsInAYear()) {
                tf = thatTf;
            }
        }
        if (that.hasEndPeriod()) {
            thatTf = that.getEndPeriod().getTimeFormatOfDate();
            if (tf == null) {
                tf = thatTf;
            } else if (thatTf.getPeriodsInAYear() > tf.getPeriodsInAYear()) {
                tf = thatTf;
            }
        }
        boolean thisIsSubset = false;
        switch (this.getOverlap(that)) {
            case EXACT_MATCH: {
                periods.add(this);
                break;
            }
            case NOT_IN_PERIOD: {
                periods.add(this);
                periods.add(that);
                break;
            }
            case OVERLAP: {
                SdmxPeriod earlierPeriod = this.isBeforePeriod(that) ? this : that;
                SdmxPeriod laterPeriod = this == earlierPeriod ? that : this;
                Date start1 = earlierPeriod.hasStartPeriod() ? earlierPeriod.getStartPeriod().getDate() : null;
                Date start2 = laterPeriod.getStartPeriod().getDate();
                Date end1 = new Date(start2.getTime() - 1000L);
                Date end2 = earlierPeriod.getEndPeriod().getDate();
                Date start3 = new Date(end2.getTime() + 1000L);
                Date end3 = laterPeriod.hasEndPeriod() ? laterPeriod.getEndPeriod().getDate() : null;
                periods.add(new SdmxPeriodImpl(start1, end1, tf));
                periods.add(new SdmxPeriodImpl(start2, end2, tf));
                periods.add(new SdmxPeriodImpl(start3, end3, tf));
                break;
            }
            case SUBSET: {
                thisIsSubset = true;
            }
            case SUPERSET: {
                SdmxPeriod innerPeriod;
                Date start1;
                SdmxPeriod outerPeriod = thisIsSubset ? that : this;
                SdmxPeriod sdmxPeriod = innerPeriod = thisIsSubset ? this : that;
                if (this.isStartEqual(that) || this.isEndEqual(that)) {
                    start1 = outerPeriod.hasStartPeriod() ? outerPeriod.getStartPeriod().getDate() : null;
                    Date end1 = this.isStartEqual(that) ? innerPeriod.getEndPeriod().getDate() : new Date(innerPeriod.getStartPeriod().getDate().getTime() - 1000L);
                    Date start2 = new Date(end1.getTime() + 1000L);
                    Date end2 = outerPeriod.hasEndPeriod() ? outerPeriod.getEndPeriod().getDate() : null;
                    periods.add(new SdmxPeriodImpl(start1, end1, tf));
                    periods.add(new SdmxPeriodImpl(start2, end2, tf));
                    break;
                }
                start1 = outerPeriod.hasStartPeriod() ? outerPeriod.getStartPeriod().getDate() : null;
                Date start2 = innerPeriod.getStartPeriod().getDate();
                Date end1 = new Date(start2.getTime() - 1000L);
                Date end2 = innerPeriod.getEndPeriod().getDate();
                Date start3 = new Date(end2.getTime() + 1000L);
                Date end3 = outerPeriod.hasEndPeriod() ? outerPeriod.getEndPeriod().getDate() : null;
                periods.add(new SdmxPeriodImpl(start1, end1, tf));
                periods.add(new SdmxPeriodImpl(start2, end2, tf));
                periods.add(new SdmxPeriodImpl(start3, end3, tf));
            }
        }
        return periods;
    }

    @Override
    public boolean isStartEqual(SdmxPeriod period) {
        if (this.getStartPeriod() == null && period.getStartPeriod() == null) {
            return true;
        }
        if (this.getStartPeriod() == null || period.getStartPeriod() == null) {
            return false;
        }
        return this.getStartPeriod().getDate().getTime() == period.getStartPeriod().getDate().getTime();
    }

    @Override
    public boolean isBeforePeriod(SdmxPeriod period) {
        if (!this.hasStartPeriod()) {
            return period.hasStartPeriod();
        }
        if (!period.hasStartPeriod()) {
            return false;
        }
        return this.getStartPeriod().isEarlier(period.getStartPeriod());
    }

    @Override
    public boolean isEndEqual(SdmxPeriod period) {
        if (this.getEndPeriod() == null && period.getEndPeriod() == null) {
            return true;
        }
        if (this.getEndPeriod() == null || period.getEndPeriod() == null) {
            return false;
        }
        return this.getEndPeriod().getDate().getTime() == period.getEndPeriod().getDate().getTime();
    }

    @Override
    public boolean isAfterPeriod(SdmxPeriod period) {
        if (!this.hasEndPeriod()) {
            return period.hasEndPeriod();
        }
        if (!period.hasEndPeriod()) {
            return false;
        }
        return this.getEndPeriod().isLater(period.getEndPeriod());
    }

    @Override
    public boolean isInPeriod(SdmxPeriod period) {
        if (this.isAllPeriods || period == ALL_PERIODS) {
            return true;
        }
        if (period != null) {
            return this.isInPeriod(period.hasStartPeriod() ? period.getStartPeriod().getDate() : null, period.hasEndPeriod() ? period.getEndPeriod().getDate() : null);
        }
        return false;
    }

    @Override
    public boolean isFullyInPeriod(SdmxPeriod period) {
        boolean isOutsidePeriod;
        if (period == null) {
            return false;
        }
        boolean bl = isOutsidePeriod = period.hasStartPeriod() ? this.isBeforeStartPeriod(period.getStartPeriod().getDate()) : this.hasStartPeriod();
        if (isOutsidePeriod) {
            return false;
        }
        isOutsidePeriod = period.hasEndPeriod() ? this.isAfterEndPeriod(period.getEndPeriod().getDate()) : this.hasEndPeriod();
        return !isOutsidePeriod;
    }

    @Override
    public boolean hasStartPeriod() {
        return this.startPeriod != null;
    }

    @Override
    public boolean hasEndPeriod() {
        return this.endPeriod != null;
    }

    @Override
    public boolean isInPeriod(Date dateFrom, Date dateTo) {
        if (this.isAllPeriods) {
            return true;
        }
        return (dateTo == null || !this.isBeforeStartPeriod(dateTo)) && (dateFrom == null || !this.isAfterEndPeriod(dateFrom));
    }

    @Override
    public boolean isBeforeStartPeriod(Date date) {
        if (this.isAllPeriods) {
            return false;
        }
        if (date != null) {
            if (!this.hasStartPeriod()) {
                return false;
            }
            return date.before(this.getStartPeriod().getDate());
        }
        return this.startPeriod != null;
    }

    @Override
    public boolean isAfterEndPeriod(Date date) {
        if (this.isAllPeriods) {
            return false;
        }
        if (date != null) {
            if (!this.hasEndPeriod()) {
                return false;
            }
            return date.after(this.getEndPeriod().getDate());
        }
        return false;
    }

    @Override
    public boolean isInPeriod(Date date) {
        if (this.isAllPeriods) {
            return true;
        }
        if (this.hasStartPeriod() && date.before(this.getStartPeriod().getDate())) {
            return false;
        }
        return !this.hasEndPeriod() || !date.after(this.getEndPeriod().getDate());
    }

    @Override
    public int compareTo(SdmxPeriod o) {
        int result;
        if (o == this) {
            return 0;
        }
        if (this.startPeriod == null && o.getStartPeriod() != null) {
            return -1;
        }
        if (this.startPeriod != null && o.getStartPeriod() == null) {
            return 1;
        }
        if (this.startPeriod != null && o.getStartPeriod() != null && (result = this.startPeriod.getDate().compareTo(o.getStartPeriod().getDate())) != 0) {
            return result;
        }
        if (this.endPeriod == null && o.getEndPeriod() != null) {
            return 1;
        }
        if (this.endPeriod != null && o.getEndPeriod() == null) {
            return -1;
        }
        if (this.endPeriod != null && o.getEndPeriod() != null && (result = this.endPeriod.getDate().compareTo(o.getEndPeriod().getDate())) != 0) {
            return result;
        }
        return 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SdmxPeriod) {
            SdmxPeriod that = (SdmxPeriod)obj;
            if (!ObjectUtil.equivalent(that.getStartPeriod(), this.getStartPeriod())) {
                return false;
            }
            return ObjectUtil.equivalent(that.getEndPeriod(), this.getEndPeriod());
        }
        return false;
    }

    public String toString() {
        if (this.isAllPeriods) {
            return "[All Periods]";
        }
        StringBuilder sb = new StringBuilder();
        String startPeriod = this.hasStartPeriod() ? this.getStartPeriod().getDateInSdmxFormat() : "[no start]";
        String endPeriod = this.hasEndPeriod() ? this.getEndPeriod().getDateInSdmxFormat() : "[no end]";
        sb.append(startPeriod + " - " + endPeriod);
        return sb.toString();
    }
}

