/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.date;

import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.date.TIME_FORMAT;
import io.sdmx.utils.core.date.DateUtil;
import java.util.Calendar;
import java.util.Date;

public class SdmxDateImpl
implements SdmxDate {
    private static final long serialVersionUID = 88935254909061494L;
    private Date date;
    private TIME_FORMAT timeFormat;
    private String dateInSdmx;
    private boolean startOfPeriod;

    public SdmxDateImpl(Date date, TIME_FORMAT timeFormat) {
        this(date, timeFormat, true);
    }

    public SdmxDateImpl(Date date, TIME_FORMAT timeFormat, boolean startOfPeriod) {
        if (!startOfPeriod) {
            date = DateUtil.moveToEndofPeriod(date, timeFormat);
        }
        this.date = date;
        this.timeFormat = timeFormat;
        this.startOfPeriod = startOfPeriod;
        this.dateInSdmx = DateUtil.formatDate(date, timeFormat);
    }

    public SdmxDateImpl(Long epochTime) {
        this(new Date(epochTime), TIME_FORMAT.DATE_TIME);
    }

    public SdmxDateImpl(String dateInSdmx) {
        this(dateInSdmx, true);
    }

    public SdmxDateImpl(String dateInSdmx, boolean startOfPeriod) {
        this.startOfPeriod = startOfPeriod;
        this.date = DateUtil.formatDate(dateInSdmx, startOfPeriod);
        this.timeFormat = DateUtil.getTimeFormatOfDate(dateInSdmx);
        this.dateInSdmx = dateInSdmx;
    }

    @Override
    public boolean isStartPeriod() {
        return this.startOfPeriod;
    }

    @Override
    public SdmxDate movePeriod(int increment) {
        String nextDate = DateUtil.movePeriod(this, increment);
        SdmxDateImpl sd = new SdmxDateImpl(nextDate);
        return sd;
    }

    @Override
    public boolean isLater(SdmxDate date) {
        return this.getDate().getTime() > date.getDate().getTime();
    }

    @Override
    public boolean isEarlier(SdmxDate date) {
        return this.getDate().getTime() < date.getDate().getTime();
    }

    @Override
    public Date getDate() {
        return new Date(this.date.getTime());
    }

    @Override
    public TIME_FORMAT getTimeFormatOfDate() {
        return this.timeFormat;
    }

    @Override
    public String getDateInSdmxFormat() {
        return this.dateInSdmx;
    }

    @Override
    public Calendar getDateAsCalendar() {
        return DateUtil.createCalendar(this.date);
    }

    public int hashCode() {
        return this.dateInSdmx.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SdmxDate) {
            SdmxDate that = (SdmxDate)obj;
            return that.getDateInSdmxFormat().equals(this.getDateInSdmxFormat());
        }
        return false;
    }

    public String toString() {
        return this.getDateInSdmxFormat();
    }

    @Override
    public int compareTo(SdmxDate that) {
        return this.getDate().compareTo(that.getDate());
    }
}

