/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.date;

import io.sdmx.api.date.PeriodContainer;
import io.sdmx.api.date.PeriodContents;
import io.sdmx.api.date.PeriodsContainer;
import io.sdmx.api.date.SdmxPeriod;
import io.sdmx.utils.core.date.PeriodContainerImpl;
import io.sdmx.utils.core.date.PeriodMapContainer;
import io.sdmx.utils.core.date.SdmxPeriodImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodsContainerImpl<T>
implements PeriodsContainer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodsContainerImpl.class);
    private Map<SdmxPeriod, PeriodContainer<T>> periodContainer = new HashMap<SdmxPeriod, PeriodContainer<T>>();

    public static <K, V> PeriodsContainer<Map<K, Set<V>>> getMapContainer(boolean unionOnly) {
        PeriodMapContainer contents = new PeriodMapContainer(unionOnly);
        return new PeriodsContainerImpl<Map<K, Set<V>>>(contents);
    }

    public PeriodsContainerImpl(PeriodContents<T> contents) {
        PeriodContainerImpl<T> pc = new PeriodContainerImpl<T>(SdmxPeriodImpl.ALL_PERIODS, contents);
        this.periodContainer.put(pc.getSdmxPeriod(), pc);
    }

    @Override
    public void addContents(T contents, SdmxPeriod period) {
        PeriodContainer<T> container;
        if (LOG.isTraceEnabled()) {
            LOG.trace("addContents: " + period);
        }
        if ((container = this.periodContainer.get(period)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Merge: " + period);
            }
            container.getPeriodContents().merge(contents);
            return;
        }
        HashSet<SdmxPeriod> periods = new HashSet<SdmxPeriod>(this.periodContainer.keySet());
        for (SdmxPeriod existingPeriod : periods) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("existingPeriod: " + existingPeriod);
                LOG.trace("existingPeriod: " + (Object)((Object)existingPeriod.getOverlap(period)));
            }
            switch (existingPeriod.getOverlap(period)) {
                case EXACT_MATCH: {
                    LOG.debug("Merge: " + existingPeriod);
                    this.periodContainer.get(existingPeriod).getPeriodContents().merge(contents);
                    break;
                }
                case NOT_IN_PERIOD: {
                    break;
                }
                case OVERLAP: {
                    PeriodContainer<T> pcCopy;
                    PeriodContainer<T> pc = this.periodContainer.get(existingPeriod);
                    if (pc == null) break;
                    this.periodContainer.remove(existingPeriod);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Remove: " + existingPeriod);
                    }
                    for (SdmxPeriod splitPeriod : existingPeriod.split(period)) {
                        if (this.periodContainer.containsKey(splitPeriod)) {
                            pcCopy = this.periodContainer.get(splitPeriod);
                        } else if (pc.getSdmxPeriod().isInPeriod(splitPeriod)) {
                            pcCopy = pc.copy(splitPeriod);
                        } else {
                            this.addContents(contents, splitPeriod);
                            continue;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Put: " + splitPeriod);
                        }
                        this.periodContainer.put(splitPeriod, pcCopy);
                        if (!period.isInPeriod(splitPeriod)) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Merge: " + splitPeriod);
                        }
                        pcCopy.getPeriodContents().merge(contents);
                    }
                    break;
                }
                case SUBSET: {
                    PeriodContainer<T> pc = this.periodContainer.get(existingPeriod);
                    if (pc == null) break;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Merge: " + existingPeriod);
                    }
                    pc.getPeriodContents().merge(contents);
                    break;
                }
                case SUPERSET: {
                    PeriodContainer<T> pcCopy;
                    PeriodContainer<T> pc = this.periodContainer.get(existingPeriod);
                    if (pc == null) break;
                    this.periodContainer.remove(existingPeriod);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Remove: " + existingPeriod);
                    }
                    for (SdmxPeriod splitPeriod : existingPeriod.split(period)) {
                        pcCopy = pc.copy(splitPeriod);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Put: " + splitPeriod);
                        }
                        this.periodContainer.put(splitPeriod, pcCopy);
                        if (!period.isInPeriod(splitPeriod)) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Merge: " + splitPeriod);
                        }
                        pcCopy.getPeriodContents().merge(contents);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public Set<SdmxPeriod> getPeriods() {
        return this.periodContainer.keySet();
    }

    @Override
    public T getContents(SdmxPeriod period) {
        PeriodContainer<T> container = this.periodContainer.get(period);
        if (container == null) {
            return null;
        }
        return container.getContents();
    }

    @Override
    public Map<SdmxPeriod, T> getContents() {
        HashMap<SdmxPeriod, T> returnMap = new HashMap<SdmxPeriod, T>();
        for (PeriodContainer<T> container : this.periodContainer.values()) {
            returnMap.put(container.getSdmxPeriod(), container.getContents());
        }
        return returnMap;
    }
}

