/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.date;

import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.date.SdmxPeriod;
import io.sdmx.api.date.TIME_FORMAT;
import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.SdmxNotImplementedException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.utils.core.date.SdmxDateImpl;
import io.sdmx.utils.core.date.SdmxPeriodImpl;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.object.StringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2LongAVLTreeMap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class DateUtil {
    private static final String xmlDatePatternString = "[0-9]{4}-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))";
    private static final String xmlHourPatternString = "([0-1][0-9]|2[0-3])";
    private static final Pattern xmlDateTimePattern = Pattern.compile("[0-9]{4}-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))T([0-1][0-9]|2[0-3]):([0-5][0-9]:[0-5][0-9])(\\.[0-9]*)?(Z|((\\+|-)((0[0-9]|1[0-3]):([0-5][0-9])|14:00)))?");
    private static final Pattern xmlMinutelyPattern = Pattern.compile("[0-9]{4}-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))T([0-1][0-9]|2[0-3]):([0-5][0-9])");
    private static final Pattern xmlHourlyPattern = Pattern.compile("[0-9]{4}-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))T([0-1][0-9]|2[0-3])");
    private static final Pattern xmlDailyPattern = Pattern.compile("[0-9]{4}-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))");
    private static final Pattern xmlWeeklyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-W([1-9]|0[1-9]|[1-4][0-9]|5[0-3])");
    private static final Pattern xmlMonthlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-M*(0[1-9]|1[0-2])");
    private static final Pattern xmlQuarterlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-Q[1-4]");
    private static final Pattern xmlBiAnnualPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-B[1-2]");
    private static final Pattern xmlSemiAnnualPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-S[1-2]");
    private static final Pattern xmlHalfYearlyHPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-H[1-2]");
    private static final Pattern xmlTriAnnualPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-T[1-3]");
    private static final Pattern xmlYearlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");
    private static final Pattern xmlAnnualRangePattern = Pattern.compile("[0-9][0-9][0-9][0-9]-A[1-9][0-9]*");
    public static final Pattern date_TimePattern = Pattern.compile("([0-1][0-9]|2[0-3]):([0-5][0-9]:[0-5][0-9])");
    public static final Pattern date_MonthPattern = Pattern.compile("--(0[1-9]|1[0-2])");
    public static final Pattern date_MonthDayPattern = Pattern.compile("--((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))");
    public static final Pattern date_YearMonthPattern = Pattern.compile("[0-9]{4}-(0[1-9]|1[0-2])");
    private static boolean alternateHalfYear;
    private static final ZoneId GMT_ZONEID;
    private static Long2ObjectRBTreeMap<String> formattedA;
    private static Long2ObjectRBTreeMap<String> formattedS;
    private static Long2ObjectRBTreeMap<String> formattedT;
    private static Long2ObjectRBTreeMap<String> formattedQ;
    private static Long2ObjectRBTreeMap<String> formattedM;
    private static Long2ObjectRBTreeMap<String> formattedW;
    private static Long2ObjectRBTreeMap<String> formattedD;
    private static Long2ObjectRBTreeMap<String> formattedH;
    private static Long2ObjectRBTreeMap<String> formattedI;
    private static Object2LongAVLTreeMap<String> formattedStartPeriod;
    private static Object2LongAVLTreeMap<String> formattedEndPeriod;
    private static Long2ObjectRBTreeMap<Date> datePoolStart;
    private static Long2ObjectRBTreeMap<Date> datePoolEnd;
    public static final ZoneId utcZoneId;
    public static final ZoneId defZoneId;

    public static void setUseAlternateHalfYear(boolean val) {
        alternateHalfYear = val;
    }

    private static void startCacheResetter() {
        Thread t = new Thread(new Runnable(){
            boolean isRunning = true;

            @Override
            public void run() {
                try {
                    while (this.isRunning) {
                        Thread.sleep(0x6DDD00L);
                        formattedA = new Long2ObjectRBTreeMap();
                        formattedS = new Long2ObjectRBTreeMap();
                        formattedT = new Long2ObjectRBTreeMap();
                        formattedQ = new Long2ObjectRBTreeMap();
                        formattedM = new Long2ObjectRBTreeMap();
                        formattedW = new Long2ObjectRBTreeMap();
                        formattedD = new Long2ObjectRBTreeMap();
                        formattedH = new Long2ObjectRBTreeMap();
                        formattedI = new Long2ObjectRBTreeMap();
                        formattedStartPeriod = new Object2LongAVLTreeMap();
                        formattedEndPeriod = new Object2LongAVLTreeMap();
                    }
                }
                catch (InterruptedException ie) {
                    this.isRunning = false;
                    DateUtil.startCacheResetter();
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static Date getLater(Date dte1, Date dte2) {
        if (dte1 == null) {
            return dte2;
        }
        if (dte2 == null) {
            return dte1;
        }
        return dte1.after(dte2) ? dte1 : dte2;
    }

    public static Date getEarlier(Date dte1, Date dte2) {
        if (dte1 == null) {
            return dte2;
        }
        if (dte2 == null) {
            return dte1;
        }
        return dte1.before(dte2) ? dte1 : dte2;
    }

    public static Calendar getCalendar(int calfield, int num) {
        Calendar cal = DateUtil.getCalendar(true);
        cal.add(calfield, num);
        return cal;
    }

    public static Calendar createCalendar(Date date) {
        Calendar cal = DateUtil.getCalendar(false);
        cal.setTime(date);
        return cal;
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        try {
            Calendar now = DateUtil.getCalendar(false);
            now.setTime(date);
            GregorianCalendar cal = new GregorianCalendar(now.get(1), now.get(2), now.get(5), now.get(10), now.get(12), now.get(13));
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static Date moveToEndofPeriod(Date date, TIME_FORMAT timeFormat) {
        String dateAsString = DateUtil.formatDate(date, timeFormat);
        return DateUtil.formatDateEndPeriod(dateAsString);
    }

    public static Date formatDate(Object dateObject, boolean startOfPeriod) {
        if (dateObject == null) {
            return null;
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (dateObject instanceof Long) {
            return new Date((Long)dateObject);
        }
        if (dateObject instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar gregorianCal = (XMLGregorianCalendar)dateObject;
            Calendar cal = DateUtil.getCalendar(false);
            cal.set(1, gregorianCal.getYear());
            cal.set(2, gregorianCal.getMonth() - 1);
            cal.set(5, gregorianCal.getDay());
            cal.set(9, 0);
            if (gregorianCal.getHour() > 0) {
                cal.set(10, gregorianCal.getHour());
            } else {
                cal.set(10, 0);
            }
            if (gregorianCal.getMinute() > 0) {
                cal.set(12, gregorianCal.getMinute());
            } else {
                cal.set(12, 0);
            }
            if (gregorianCal.getSecond() > 0) {
                cal.set(13, gregorianCal.getSecond());
            } else {
                cal.set(13, 0);
            }
            cal.set(14, 0);
            return cal.getTime();
        }
        String dateString = null;
        if (!(dateObject instanceof String)) {
            throw new IllegalArgumentException("Date type not recognised : " + dateObject.getClass().getName());
        }
        dateString = (String)dateObject;
        if (dateString.length() == 0) {
            return null;
        }
        if (startOfPeriod) {
            return DateUtil.formatDateStartPeriod(dateString);
        }
        return DateUtil.formatDateEndPeriod(dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date formatDateStartPeriod(String value) {
        long dte = formattedStartPeriod.getLong(value);
        if (dte != formattedStartPeriod.defaultReturnValue()) {
            Long2ObjectRBTreeMap<Date> long2ObjectRBTreeMap = datePoolStart;
            synchronized (long2ObjectRBTreeMap) {
                Date d = datePoolStart.get(dte);
                if (d != null) {
                    return d;
                }
            }
        }
        Date d = DateUtil.formatDateStartPeriodInternal(value);
        Long2ObjectRBTreeMap<Date> long2ObjectRBTreeMap = datePoolStart;
        synchronized (long2ObjectRBTreeMap) {
            datePoolStart.put(d.getTime(), d);
            formattedStartPeriod.put(value, d.getTime());
        }
        return d;
    }

    private static Date formatDateStartPeriodInternal(String value) {
        TIME_FORMAT timeFormat = DateUtil.getTimeFormatOfDate(value);
        SimpleDateFormat df = null;
        String formatValue = null;
        String[] split = null;
        int quarter = 0;
        Calendar cal = null;
        switch (timeFormat) {
            case DATE: {
                formatValue = value;
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case DATE_TIME: {
                formatValue = value;
                if (formatValue.length() == 16) {
                    df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm");
                    break;
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case HALF_OF_YEAR: {
                String splitItem = null;
                if (alternateHalfYear && value.contains("-H")) {
                    splitItem = "-H";
                }
                if (value.contains("-B")) {
                    splitItem = "-B";
                } else if (value.contains("-S")) {
                    splitItem = "-S";
                }
                if (splitItem == null) {
                    throw new RuntimeException("The observation date: " + value + " does not conform to the half yearly format expected!");
                }
                split = value.split(splitItem);
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-01-01";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-07-01";
                    }
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case HOUR: {
                formatValue = value;
                if (formatValue.length() == 13) {
                    df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH");
                    break;
                }
                if (formatValue.length() == 16) {
                    df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm");
                    break;
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case MONTH: {
                if (value.charAt(5) == 'M') {
                    value = value.substring(0, 5) + value.substring(6);
                }
                formatValue = value + "-01";
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case QUARTER_OF_YEAR: {
                split = value.split("-Q");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-01-01";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-04-01";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-07-01";
                        break;
                    }
                    case 4: {
                        formatValue = split[0] + "-10-01";
                    }
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case THIRD_OF_YEAR: {
                split = value.split("-T");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-01-01";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-05-01";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-09-01";
                    }
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case WEEK: {
                split = value.split("-W");
                cal = DateUtil.getCalendar(false);
                cal.set(7, 2);
                cal.set(1, Integer.parseInt(split[0]));
                cal.set(3, Integer.parseInt(split[1]));
                return cal.getTime();
            }
            case YEAR: {
                formatValue = value + "-01-01";
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case YEAR_RANGE: {
                formatValue = value.split("-")[0] + "-01-01";
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "formatting date of type " + (Object)((Object)timeFormat));
            }
        }
        try {
            return df.parse(formatValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date formatDateEndPeriod(String value) {
        long dte = formattedEndPeriod.getLong(value);
        if (dte != formattedEndPeriod.defaultReturnValue()) {
            Long2ObjectRBTreeMap<Date> long2ObjectRBTreeMap = datePoolEnd;
            synchronized (long2ObjectRBTreeMap) {
                Date d = datePoolEnd.get(dte);
                if (d != null) {
                    return d;
                }
            }
        }
        Date d = DateUtil.formatDateEndPeriodInternal(value);
        Long2ObjectRBTreeMap<Date> long2ObjectRBTreeMap = datePoolEnd;
        synchronized (long2ObjectRBTreeMap) {
            datePoolEnd.put(d.getTime(), d);
            formattedEndPeriod.put(value, d.getTime());
        }
        return d;
    }

    private static Date formatDateEndPeriodInternal(String value) {
        TIME_FORMAT timeFormat = DateUtil.getTimeFormatOfDate(value);
        DateFormat df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
        String formatValue = null;
        String[] split = null;
        int days = 0;
        int quarter = 0;
        Calendar cal = null;
        switch (timeFormat) {
            case DATE: {
                formatValue = value;
                formatValue = formatValue + "T23:59:59";
                break;
            }
            case DATE_TIME: {
                formatValue = value;
                formatValue = formatValue.split("T")[0];
                formatValue = formatValue + "T23:59:59";
                df = DateUtil.getDateTimeFormat();
                break;
            }
            case HALF_OF_YEAR: {
                String splitItem = null;
                if (alternateHalfYear && value.contains("-H")) {
                    splitItem = "-H";
                }
                if (value.contains("-B")) {
                    splitItem = "-B";
                } else if (value.contains("-S")) {
                    splitItem = "-S";
                }
                if (splitItem == null) {
                    throw new RuntimeException("The observation date: " + value + " does not conform to the half yearly format expected!");
                }
                split = value.split(splitItem);
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-06-30T23:59:59";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-12-31T23:59:59";
                    }
                }
                break;
            }
            case HOUR: {
                formatValue = value;
                if (formatValue.length() == 13) {
                    formatValue = formatValue + ":59:59";
                } else if (formatValue.length() == 16) {
                    formatValue = formatValue + ":59:59";
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case MONTH: {
                split = value.split("-");
                cal = DateUtil.getCalendar(false);
                cal.clear();
                cal.set(1, Integer.parseInt(split[0]));
                if (value.charAt(5) == 'M') {
                    split[1] = split[1].substring(1);
                    value = value.substring(0, 5) + value.substring(6);
                }
                cal.set(2, Integer.parseInt(split[1]) - 1);
                days = cal.getActualMaximum(5);
                formatValue = value + "-" + days + "T23:59:59";
                break;
            }
            case QUARTER_OF_YEAR: {
                split = value.split("-Q");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-03-31T23:59:59";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-06-30T23:59:59";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-09-30T23:59:59";
                        break;
                    }
                    case 4: {
                        formatValue = split[0] + "-12-31T23:59:59";
                    }
                }
                break;
            }
            case THIRD_OF_YEAR: {
                split = value.split("-T");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-04-30T23:59:59";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-08-31T23:59:59";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-12-31T23:59:59";
                    }
                }
                break;
            }
            case WEEK: {
                split = value.split("-W");
                cal = DateUtil.getCalendar(false);
                cal.set(7, 1);
                cal.set(1, Integer.parseInt(split[0]));
                cal.set(3, Integer.parseInt(split[1]));
                cal.set(10, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                return cal.getTime();
            }
            case YEAR: {
                formatValue = value + "-12-31T23:59:59";
                break;
            }
            case YEAR_RANGE: {
                Integer year = Integer.parseInt(value.split("-")[0]);
                Integer periods = Integer.parseInt(value.split("-")[1].substring(1));
                formatValue = year + periods + "-12-31T23:59:59";
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "formatting date of type " + (Object)((Object)timeFormat));
            }
        }
        try {
            return df.parse(formatValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isSdmxDate(String dateStr) {
        if (dateStr == null) {
            return false;
        }
        if (dateStr.endsWith("Z")) {
            dateStr = dateStr.substring(0, dateStr.length() - 1);
        }
        if (xmlAnnualRangePattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlYearlyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlTriAnnualPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlSemiAnnualPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlBiAnnualPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlQuarterlyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlMonthlyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlWeeklyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlDailyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlHourlyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlMinutelyPattern.matcher(dateStr).matches()) {
            return true;
        }
        if (xmlDateTimePattern.matcher(dateStr).matches()) {
            return true;
        }
        return alternateHalfYear && xmlHalfYearlyHPattern.matcher(dateStr).matches();
    }

    public static TIME_FORMAT getTimeFormatOfDate(String dateStr) {
        if (dateStr == null) {
            throw new IllegalArgumentException("Could not determine date format, date null");
        }
        if (dateStr.endsWith("Z")) {
            dateStr = dateStr.substring(0, dateStr.length() - 1);
        }
        if (xmlYearlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.YEAR;
        }
        if (xmlSemiAnnualPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HALF_OF_YEAR;
        }
        if (xmlBiAnnualPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HALF_OF_YEAR;
        }
        if (xmlQuarterlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.QUARTER_OF_YEAR;
        }
        if (xmlMonthlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.MONTH;
        }
        if (xmlWeeklyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.WEEK;
        }
        if (xmlDailyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.DATE;
        }
        if (xmlHourlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HOUR;
        }
        if (xmlMinutelyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HOUR;
        }
        if (xmlDateTimePattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.DATE_TIME;
        }
        if (xmlTriAnnualPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.THIRD_OF_YEAR;
        }
        if (alternateHalfYear && xmlHalfYearlyHPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HALF_OF_YEAR;
        }
        if (xmlAnnualRangePattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.YEAR_RANGE;
        }
        throw new SdmxSemmanticException(ExceptionCode.INVALID_DATE_FORMAT, dateStr);
    }

    public static String formatDate(Date aDate) {
        return DateUtil.formatDate(aDate, false);
    }

    public static String formatDate(Date dt, boolean includeTimeZone) {
        if (dt == null) {
            return null;
        }
        DateFormat df = DateUtil.getDateTimeFormat(includeTimeZone);
        return df.format(dt);
    }

    public static DateFormat getDateTimeFormat() {
        return DateUtil.getDateTimeFormat(false);
    }

    public static DateFormat getDateTimeFormat(boolean includeTimeZone) {
        if (includeTimeZone) {
            return DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
        return DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
    }

    public static DateFormat getDateFormat() {
        return DateUtil.getDateFormatter("yyyy-MM-dd");
    }

    public static DateFormat getYearFormat() {
        return DateUtil.getDateFormatter("yyyy");
    }

    public static DateFormat getMonthFormat() {
        return DateUtil.getDateFormatter("yyyy-MM");
    }

    public static DateFormat geWeekFormat() {
        return DateUtil.getDateFormatter("yyyy-ww");
    }

    public static DateFormat geHourFormat() {
        return DateUtil.getDateFormatter("yyyy-MM-dd'T'HH");
    }

    public static SortedMap<String, SortedSet<String>> groupByFrequency(Collection<String> inputDates, TIME_FORMAT targetFrequency) {
        TreeMap<String, SortedSet<String>> returnMap = new TreeMap<String, SortedSet<String>>();
        for (String currentInputDate : inputDates) {
            String converted = DateUtil.convertFrequency(currentInputDate, targetFrequency);
            TreeSet<String> datesForFreq = (TreeSet<String>)returnMap.get(converted);
            if (datesForFreq == null) {
                datesForFreq = new TreeSet<String>();
                returnMap.put(converted, datesForFreq);
            }
            datesForFreq.add(currentInputDate);
        }
        return returnMap;
    }

    public static List<String> findMissingPeriods(Collection<String> periods, SdmxDate startPeriod, SdmxDate endPeriod, boolean includeProvidedPeriods) {
        SdmxDateImpl lasstSdmxDate;
        TIME_FORMAT tf;
        if (!ObjectUtil.validCollection(periods)) {
            return Collections.emptyList();
        }
        TreeSet<String> sortedPeriods = new TreeSet<String>(periods);
        ArrayList<String> returnPeriods = new ArrayList<String>();
        String firstDate = (String)sortedPeriods.first();
        if (startPeriod != null) {
            SdmxDateImpl firstSdmxDate = new SdmxDateImpl(firstDate, true);
            tf = firstSdmxDate.getTimeFormatOfDate();
            if (startPeriod.isEarlier(firstSdmxDate)) {
                firstDate = startPeriod.getDateInSdmxFormat();
            }
        } else {
            tf = DateUtil.getTimeFormatOfDate(firstDate);
        }
        String lastDate = (String)sortedPeriods.last();
        if (endPeriod != null && endPeriod.isLater(lasstSdmxDate = new SdmxDateImpl(lastDate, true))) {
            lastDate = endPeriod.getDateInSdmxFormat();
        }
        List<String> allValues = DateUtil.createTimeValues(DateUtil.formatDate(firstDate, true), DateUtil.formatDate(lastDate, true), tf);
        if (includeProvidedPeriods) {
            return allValues;
        }
        for (String currentDate : allValues) {
            if (sortedPeriods.contains(currentDate)) continue;
            returnPeriods.add(currentDate);
        }
        return returnPeriods;
    }

    public static String convertFrequency(String date, TIME_FORMAT targetFrequency) {
        return DateUtil.formatDate(date, targetFrequency, true);
    }

    public static String movePeriod(SdmxDate date, int periods) {
        if (periods == 0) {
            return date.getDateInSdmxFormat();
        }
        Calendar cal = date.getDateAsCalendar();
        int duration = 0;
        switch (date.getTimeFormatOfDate()) {
            case DATE: {
                duration = 5;
                break;
            }
            case DATE_TIME: {
                duration = 13;
                break;
            }
            case HALF_OF_YEAR: {
                duration = 2;
                periods *= 6;
                break;
            }
            case HOUR: {
                duration = 10;
                break;
            }
            case MONTH: {
                duration = 2;
                break;
            }
            case QUARTER_OF_YEAR: {
                duration = 2;
                periods *= 3;
                break;
            }
            case THIRD_OF_YEAR: {
                duration = 2;
                periods *= 4;
                break;
            }
            case WEEK: {
                LocalDate jodaTime = new LocalDate((Object)date.getDate(), DateTimeZone.UTC);
                jodaTime = jodaTime.plusWeeks(periods);
                return DateUtil.formatDate(jodaTime.toDateTimeAtStartOfDay(DateTimeZone.UTC).toDate(), date.getTimeFormatOfDate());
            }
            case YEAR: {
                duration = 1;
            }
        }
        cal.add(duration, periods);
        return DateUtil.formatDate(cal.getTime(), date.getTimeFormatOfDate());
    }

    public static long getTimePeriodCount(Date dateFrom, Date dateTo, TIME_FORMAT format) {
        long duration = 0L;
        switch (format) {
            case DATE: {
                duration = 86400000L;
                break;
            }
            case DATE_TIME: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{format});
            }
            case HALF_OF_YEAR: {
                duration = 15768000000L;
                break;
            }
            case HOUR: {
                duration = 3600000L;
                break;
            }
            case MONTH: {
                duration = 2628000000L;
                break;
            }
            case QUARTER_OF_YEAR: {
                duration = 7884000000L;
                break;
            }
            case THIRD_OF_YEAR: {
                duration = 10512000000L;
                break;
            }
            case WEEK: {
                duration = 604800000L;
                break;
            }
            case YEAR: {
                duration = 31536000000L;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported time format : " + (Object)((Object)format));
            }
        }
        long diff = dateTo.getTime() - dateFrom.getTime();
        if (diff == 0L) {
            return 0L;
        }
        return diff / duration;
    }

    public static List<String> createTimeValues(SdmxPeriod period) {
        if (!period.hasStartPeriod()) {
            throw new SdmxSemmanticException("Missing Start Period");
        }
        if (!period.hasEndPeriod()) {
            throw new SdmxSemmanticException("Missing End Period");
        }
        return DateUtil.createTimeValues(period.getStartPeriod().getDate(), period.getEndPeriod().getDate(), period.getStartPeriod().getTimeFormatOfDate());
    }

    public static List<String> createTimeValues(Date dateFrom, Date dateTo, TIME_FORMAT format) {
        ArrayList<String> returnList = new ArrayList<String>();
        switch (format) {
            case DATE: {
                DateUtil.iterateDailyValues(dateFrom, dateTo, returnList);
                break;
            }
            case DATE_TIME: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{format});
            }
            case HALF_OF_YEAR: {
                DateUtil.iterateHalfYearlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case HOUR: {
                DateUtil.iterateHourlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case MONTH: {
                DateUtil.iterateMonthlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case QUARTER_OF_YEAR: {
                DateUtil.iterateQuarterlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case THIRD_OF_YEAR: {
                DateUtil.iterateThirdOfYearValues(dateFrom, dateTo, returnList);
                break;
            }
            case WEEK: {
                DateUtil.iterateWeeklyValues(dateFrom, dateTo, returnList);
                break;
            }
            case YEAR: {
                DateUtil.iterateYearlyValues(dateFrom, dateTo, returnList);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported time format : " + (Object)((Object)format));
            }
        }
        return returnList;
    }

    private static void iterateDailyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 5, 1, TIME_FORMAT.DATE);
    }

    private static void iterateHalfYearlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 2, 6, TIME_FORMAT.HALF_OF_YEAR);
    }

    private static void iterateHourlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 10, 1, TIME_FORMAT.HOUR);
    }

    private static void iterateMonthlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateMonthValue(dateFrom, dateTo, returnList, 1, TIME_FORMAT.MONTH);
    }

    private static void iterateQuarterlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateMonthValue(dateFrom, dateTo, returnList, 3, TIME_FORMAT.QUARTER_OF_YEAR);
    }

    private static void iterateThirdOfYearValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 2, 4, TIME_FORMAT.THIRD_OF_YEAR);
    }

    private static void iterateWeeklyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateWeekValue(dateFrom, dateTo, returnList, 1, TIME_FORMAT.WEEK);
    }

    private static void iterateYearlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 1, 1, TIME_FORMAT.YEAR);
    }

    private static void iterateDateValues(Date dateFrom, Date dateTo, List<String> returnList, int duration, int number, TIME_FORMAT format) {
        Calendar cal = DateUtil.getCalendar(false);
        cal.setTime(dateFrom);
        Calendar calTo = DateUtil.getCalendar(false);
        calTo.setTime(dateTo);
        while (!cal.getTime().after(calTo.getTime())) {
            returnList.add(DateUtil.formatDate(cal.getTime(), format));
            cal.add(duration, number);
        }
    }

    private static void iterateMonthValue(Date dateFrom, Date dateTo, List<String> returnList, int number, TIME_FORMAT format) {
        LocalDate dateTimeFrom = new LocalDate((Object)dateFrom, DateTimeZone.UTC);
        LocalDate dateTimeTo = new LocalDate((Object)dateTo, DateTimeZone.UTC);
        while (!dateTimeFrom.isAfter(dateTimeTo)) {
            returnList.add(DateUtil.formatDate(dateTimeFrom.toDateTimeAtStartOfDay(DateTimeZone.UTC).toDate(), format));
            dateTimeFrom = dateTimeFrom.plusMonths(number);
        }
    }

    private static void iterateWeekValue(Date dateFrom, Date dateTo, List<String> returnList, int number, TIME_FORMAT format) {
        LocalDate dateTimeFrom = new LocalDate((Object)dateFrom, DateTimeZone.UTC);
        LocalDate dateTimeTo = new LocalDate((Object)dateTo, DateTimeZone.UTC);
        while (!dateTimeFrom.isAfter(dateTimeTo)) {
            returnList.add(DateUtil.formatDate(dateTimeFrom.toDateTimeAtStartOfDay(DateTimeZone.UTC).toDate(), format));
            dateTimeFrom = dateTimeFrom.plusWeeks(number);
        }
    }

    public static String formatDate(String date, TIME_FORMAT format, boolean startOfPeriod) {
        Date d = DateUtil.formatDate(date, startOfPeriod);
        return DateUtil.formatDate(d, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, TIME_FORMAT format) {
        if (date == null) {
            return null;
        }
        String returnVal = null;
        long timeL = date.getTime();
        switch (format) {
            case YEAR: {
                returnVal = formattedA.get(timeL);
                break;
            }
            case HALF_OF_YEAR: {
                returnVal = formattedS.get(timeL);
                break;
            }
            case THIRD_OF_YEAR: {
                returnVal = formattedT.get(timeL);
                break;
            }
            case QUARTER_OF_YEAR: {
                returnVal = formattedQ.get(timeL);
                break;
            }
            case MONTH: {
                returnVal = formattedM.get(timeL);
                break;
            }
            case WEEK: {
                returnVal = formattedW.get(timeL);
                break;
            }
            case DATE: {
                returnVal = formattedD.get(timeL);
                break;
            }
            case HOUR: {
                returnVal = formattedH.get(timeL);
                break;
            }
            case DATE_TIME: {
                returnVal = formattedI.get(timeL);
            }
        }
        if (returnVal != null) {
            return returnVal;
        }
        returnVal = StringUtil.manualIntern(DateUtil.formatDateInternal(date, format));
        switch (format) {
            case YEAR: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedA;
                synchronized (long2ObjectRBTreeMap) {
                    formattedA.put(timeL, returnVal);
                    break;
                }
            }
            case HALF_OF_YEAR: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedS;
                synchronized (long2ObjectRBTreeMap) {
                    formattedS.put(timeL, returnVal);
                    break;
                }
            }
            case THIRD_OF_YEAR: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedT;
                synchronized (long2ObjectRBTreeMap) {
                    formattedT.put(timeL, returnVal);
                    break;
                }
            }
            case QUARTER_OF_YEAR: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedQ;
                synchronized (long2ObjectRBTreeMap) {
                    formattedQ.put(timeL, returnVal);
                    break;
                }
            }
            case MONTH: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedM;
                synchronized (long2ObjectRBTreeMap) {
                    formattedM.put(timeL, returnVal);
                    break;
                }
            }
            case WEEK: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedW;
                synchronized (long2ObjectRBTreeMap) {
                    formattedW.put(timeL, returnVal);
                    break;
                }
            }
            case DATE: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedD;
                synchronized (long2ObjectRBTreeMap) {
                    formattedD.put(timeL, returnVal);
                    break;
                }
            }
            case HOUR: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedH;
                synchronized (long2ObjectRBTreeMap) {
                    formattedH.put(timeL, returnVal);
                    break;
                }
            }
            case DATE_TIME: {
                Long2ObjectRBTreeMap<String> long2ObjectRBTreeMap = formattedI;
                synchronized (long2ObjectRBTreeMap) {
                    formattedI.put(timeL, returnVal);
                    break;
                }
            }
        }
        return returnVal;
    }

    private static String formatDateInternal(Date date, TIME_FORMAT format) {
        DateFormat df = null;
        String formatted = null;
        switch (format) {
            case DATE: {
                df = DateUtil.getDateFormat();
                return df.format(date);
            }
            case DATE_TIME: {
                df = DateUtil.getDateTimeFormat();
                return df.format(date);
            }
            case YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar(false);
                cal.setTime(date);
                return formatted;
            }
            case HALF_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar(false);
                cal.setTime(date);
                formatted = cal.get(2) <= 5 ? formatted + "-S1" : formatted + "-S2";
                return formatted;
            }
            case HOUR: {
                df = DateUtil.geHourFormat();
                return df.format(date);
            }
            case MONTH: {
                df = DateUtil.getMonthFormat();
                return df.format(date);
            }
            case QUARTER_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar(false);
                cal.setTime(date);
                formatted = cal.get(2) <= 2 ? formatted + "-Q1" : (cal.get(2) <= 5 ? formatted + "-Q2" : (cal.get(2) <= 8 ? formatted + "-Q3" : formatted + "-Q4"));
                return formatted;
            }
            case THIRD_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar(false);
                cal.setTime(date);
                formatted = cal.get(2) <= 3 ? formatted + "-T1" : (cal.get(2) <= 7 ? formatted + "-T2" : formatted + "-T3");
                return formatted;
            }
            case WEEK: {
                LocalDate dateTimeFrom = new LocalDate((Object)date, DateTimeZone.UTC);
                int weekNum = dateTimeFrom.getWeekOfWeekyear();
                String weekNumStr = weekNum < 10 ? "0" + weekNum : "" + weekNum;
                int year = dateTimeFrom.getWeekyear();
                formatted = year + "-W" + weekNumStr;
                return formatted;
            }
        }
        return null;
    }

    public static String getDateTimeStringNow() {
        SimpleDateFormat df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date d = new Date();
        return df.format(d);
    }

    @Deprecated
    public static Calendar getCalendar() {
        return DateUtil.getCalendar(false);
    }

    public static Calendar getCalendar(boolean defaultToNow) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        if (defaultToNow) {
            cal.setTime(new Date());
        }
        return cal;
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = DateUtil.getCalendar(false);
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date parseDate(String date, String dateFormat) {
        SimpleDateFormat sdf = DateUtil.getDateFormatter(dateFormat);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static SimpleDateFormat getDateFormatter(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.getCalendar().setMinimalDaysInFirstWeek(4);
        sdf.getCalendar().setFirstDayOfWeek(2);
        return sdf;
    }

    public static String formatDateForSdmxVersion21(String aDate) {
        if (aDate == null) {
            return null;
        }
        if (aDate.length() != 7) {
            return aDate;
        }
        char identifier = aDate.charAt(5);
        if (identifier == 'B') {
            char[] chars = aDate.toCharArray();
            chars[5] = 83;
            return String.valueOf(chars);
        }
        return aDate;
    }

    public static String formatDateForSdmxVersion2(String aDate) {
        if (aDate == null) {
            return null;
        }
        if (aDate.length() != 7) {
            return aDate;
        }
        char identifier = aDate.charAt(5);
        if (identifier == 'S') {
            char[] chars = aDate.toCharArray();
            chars[5] = 66;
            return String.valueOf(chars);
        }
        return aDate;
    }

    public static String formatDateForSdmxVersion1(String aDate) {
        if (aDate == null) {
            return null;
        }
        if (aDate.length() != 7) {
            return aDate;
        }
        char identifier = aDate.charAt(5);
        if (identifier == 'Q') {
            return DateUtil.convertQuarterlyDateToMonthly(aDate);
        }
        if (identifier == 'S') {
            return DateUtil.convertBiAnnualDateToMonthly(aDate);
        }
        return aDate;
    }

    private static String convertQuarterlyDateToMonthly(String quarterlyDate) {
        String quarter = quarterlyDate.substring(5, 7);
        String replace = "01";
        if (quarter.equals("Q1")) {
            replace = "01";
        } else if (quarter.equals("Q2")) {
            replace = "04";
        } else if (quarter.equals("Q3")) {
            replace = "07";
        } else if (quarter.equals("Q4")) {
            replace = "10";
        }
        return quarterlyDate.replace(quarter, replace);
    }

    private static String convertBiAnnualDateToMonthly(String biAnnualDate) {
        String theDate = biAnnualDate.substring(5, 7);
        String replace = theDate.equals("S1") ? "01" : "07";
        return biAnnualDate.replace(theDate, replace);
    }

    public static String formatDateToHttpDate(Date toFormat) {
        if (toFormat == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(toFormat);
    }

    public static Optional<SdmxPeriod> parseStartAndEndDateToSdmxPeriod(Date startDate, Date endDate) {
        SdmxDateImpl startDateObj = null;
        SdmxDateImpl endDateObj = null;
        SdmxPeriodImpl period = null;
        if (startDate != null) {
            startDateObj = new SdmxDateImpl(startDate, TIME_FORMAT.DATE_TIME);
        }
        if (endDate != null) {
            endDateObj = new SdmxDateImpl(endDate, TIME_FORMAT.DATE_TIME);
        }
        if (ObjectUtil.validOneObject(startDateObj, endDateObj)) {
            period = new SdmxPeriodImpl(startDateObj, endDateObj);
        }
        return Optional.ofNullable(period);
    }

    public static boolean isNextSequentialDate(SdmxDate date1, SdmxDate date2) {
        if (date1.getTimeFormatOfDate() != date2.getTimeFormatOfDate()) {
            return false;
        }
        SdmxDate sd = date1.movePeriod(1);
        return sd.equals(date2);
    }

    public static Date localDateTime2Date(LocalDateTime ldt, ZoneId zi) {
        return Date.from(ldt.toInstant(zi.getRules().getOffset(ldt)));
    }

    public static LocalDateTime date2LocalDateTime(Date d, ZoneId zi) {
        return LocalDateTime.ofInstant(d.toInstant(), zi);
    }

    public static Date dateDefault2Utc(Date d) {
        return DateUtil.localDateTime2Date(DateUtil.date2LocalDateTime(d, defZoneId), utcZoneId);
    }

    public static Date dateUtc2Default(Date d) {
        return DateUtil.localDateTime2Date(DateUtil.date2LocalDateTime(d, utcZoneId), defZoneId);
    }

    public static String convertEpochTimeToIso8601(long epochTime) {
        Instant ins = Instant.ofEpochMilli(epochTime);
        DateTimeFormatter gmtStyleFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(GMT_ZONEID);
        return gmtStyleFormatter.format(ins);
    }

    static {
        GMT_ZONEID = ZoneId.of("GMT");
        formattedA = new Long2ObjectRBTreeMap();
        formattedS = new Long2ObjectRBTreeMap();
        formattedT = new Long2ObjectRBTreeMap();
        formattedQ = new Long2ObjectRBTreeMap();
        formattedM = new Long2ObjectRBTreeMap();
        formattedW = new Long2ObjectRBTreeMap();
        formattedD = new Long2ObjectRBTreeMap();
        formattedH = new Long2ObjectRBTreeMap();
        formattedI = new Long2ObjectRBTreeMap();
        formattedStartPeriod = new Object2LongAVLTreeMap();
        formattedEndPeriod = new Object2LongAVLTreeMap();
        DateUtil.startCacheResetter();
        datePoolStart = new Long2ObjectRBTreeMap();
        datePoolEnd = new Long2ObjectRBTreeMap();
        utcZoneId = ZoneId.of("UTC");
        defZoneId = ZoneId.systemDefault();
    }
}

