/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.csv;

import com.opencsv.ResultSetHelper;
import com.opencsv.ResultSetHelperService;
import io.sdmx.api.csv.DELIMITER;
import io.sdmx.utils.core.io.StreamUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public class FusionCsvWriter {
    public static final int INITIAL_STRING_SIZE = 128;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    private ResultSetHelper resultService = new ResultSetHelperService();
    private int linesWritten = 0;

    public FusionCsvWriter(OutputStream out) {
        this(out, DELIMITER.COMMA, true);
    }

    public FusionCsvWriter(OutputStream out, DELIMITER delimiter) {
        this(out, delimiter, true);
    }

    public FusionCsvWriter(OutputStream out, DELIMITER delimiter, boolean outputBOM) {
        this(StreamUtil.getPrintWriterUTF8(out, outputBOM), delimiter.getDelimiter());
    }

    public FusionCsvWriter(Writer writer) {
        this(writer, ',');
    }

    public FusionCsvWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public FusionCsvWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public FusionCsvWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public FusionCsvWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public FusionCsvWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines, boolean applyQuotesToAll) {
        for (String[] line : allLines) {
            this.writeNext(line, applyQuotesToAll);
        }
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    protected void writeColumnNames(ResultSet rs) throws SQLException {
        this.writeNext(this.resultService.getColumnNames(rs));
    }

    public void writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        this.writeAll(rs, includeColumnNames, false);
    }

    public void writeAll(ResultSet rs, boolean includeColumnNames, boolean trim) throws SQLException, IOException {
        if (includeColumnNames) {
            this.writeColumnNames(rs);
        }
        while (rs.next()) {
            this.writeNext(this.resultService.getColumnValues(rs, trim));
        }
    }

    public void writeLine(Collection<String> values) {
        String[] line = values.toArray(new String[0]);
        this.writeNext(line);
    }

    public void writeLine(Collection<String> values, boolean applyQuotesToAll) {
        String[] line = values.toArray(new String[0]);
        this.writeNext(line, applyQuotesToAll);
    }

    public void writeLine(String ... values) {
        this.writeNext(values);
    }

    public void writeLine(boolean applyQuotesToAll, String ... values) {
        this.writeNext(values, applyQuotesToAll);
    }

    public void writeNext(String[] nextLine, boolean applyQuotesToAll) {
        StringBuilder ret = this.convertStringArrayToStringBuilder(nextLine, applyQuotesToAll);
        if (ret == null) {
            return;
        }
        ret.append(this.lineEnd);
        ++this.linesWritten;
        this.pw.write(ret.toString());
    }

    public String getCSVString(String[] nextLine, boolean applyQuotesToAll) {
        StringBuilder ret = this.convertStringArrayToStringBuilder(nextLine, applyQuotesToAll);
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    private StringBuilder convertStringArrayToStringBuilder(String[] nextLine, boolean applyQuotesToAll) {
        if (nextLine == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) {
                nextElement = "";
            }
            if (applyQuotesToAll) {
                sb.append(this.quotechar);
                sb.append(nextElement);
                sb.append(this.quotechar);
                continue;
            }
            sb.append(nextElement);
        }
        return sb;
    }

    public String escapeString(String input, boolean applyQuotesToAll) {
        if (input == null) {
            return null;
        }
        Boolean stringContainsSpecialCharacters = this.stringContainsSpecialCharacters(input);
        if (this.quotechar == '\u0000' || !applyQuotesToAll && !stringContainsSpecialCharacters.booleanValue()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
            sb.append(this.quotechar);
        }
        if (stringContainsSpecialCharacters.booleanValue()) {
            sb.append((CharSequence)this.processLine(input));
        } else {
            sb.append(input);
        }
        if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
            sb.append(this.quotechar);
        }
        return sb.toString();
    }

    public void writeNext(String[] nextLine) {
        this.writeNext(nextLine, false);
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1 || line.indexOf(this.separator) != -1 || line.contains(DEFAULT_LINE_END) || line.contains("\r");
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            this.processCharacter(sb, nextChar);
        }
        return sb;
    }

    private void processCharacter(StringBuilder sb, char nextChar) {
        if (this.escapechar != '\u0000' && (nextChar == this.quotechar || nextChar == this.escapechar)) {
            sb.append(this.escapechar).append(nextChar);
        } else {
            sb.append(nextChar);
        }
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    public void close() {
        try {
            this.flush();
            this.pw.close();
            this.rawWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    public void flushQuietly() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

