/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.csv;

import com.opencsv.CSVParser;
import io.sdmx.api.csv.CellReaderEngine;
import io.sdmx.api.date.SdmxDate;
import io.sdmx.api.date.TIME_FORMAT;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.api.format.FormatDetails;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.date.DateUtil;
import io.sdmx.utils.core.date.SdmxDateImpl;
import io.sdmx.utils.core.format.FormatDetailsImpl;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.xlsx.ExcelUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CSVReaderEngine
implements CellReaderEngine {
    private int sheetIndex = -1;
    private int rowIndex = -1;
    private int cellIndex = -1;
    private ReadableDataLocation rdl;
    private InputStream inputStream;
    private BufferedReader br;
    private String[] currentLine;
    private CSVParser parser = new CSVParser();
    private boolean endOfFileReached;

    public CSVReaderEngine(ReadableDataLocation rdl) {
        this.rdl = rdl;
        this.reset();
    }

    @Override
    public String getDataFormat() {
        return "CSV";
    }

    @Override
    public boolean moveNextWorkSheet() {
        if (this.sheetIndex < 0) {
            ++this.sheetIndex;
            return true;
        }
        return false;
    }

    @Override
    public String getCellReference() {
        return ExcelUtil.toCellReference(this.cellIndex, this.rowIndex);
    }

    @Override
    public FormatDetails getFormatDetails() {
        return new FormatDetailsImpl("CSV", "csv", "text/csv", true, true, new String[0]);
    }

    @Override
    public String getSheetName() {
        return null;
    }

    @Override
    public void resetSheet() {
    }

    @Override
    public boolean hasComments() {
        return false;
    }

    @Override
    public int getSkippedRows() {
        return 0;
    }

    @Override
    public List<String> getComments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean setCurrentRow(int targetRow) {
        this.cellIndex = -1;
        if (this.rowIndex == targetRow) {
            return true;
        }
        if (targetRow < this.rowIndex) {
            this.reset();
            this.moveNextWorkSheet();
        }
        int skip = targetRow - this.rowIndex;
        skip = 1;
        String curLine = null;
        try {
            for (int i = 0; i < skip; ++i) {
                curLine = this.br.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to move to row: " + targetRow);
        }
        this.setCurrentLine(curLine);
        this.rowIndex = targetRow;
        return true;
    }

    private void setCurrentLine(String curLine) {
        try {
            this.currentLine = this.parser.parseLine(curLine);
        }
        catch (IOException e) {
            throw new SdmxException(e, "Unable to parse the current line: " + curLine);
        }
    }

    @Override
    public int getCurrentRowIdx() {
        return this.rowIndex;
    }

    @Override
    public boolean moveNextRow(boolean skipNulls) {
        do {
            this.setCurrentRow(this.rowIndex + 1);
            if (!ObjectUtil.validOneString(this.currentLine)) continue;
            return true;
        } while (skipNulls && this.currentLine != null);
        this.endOfFileReached = true;
        return false;
    }

    @Override
    public boolean setCurrentCell(int cellIdx) {
        if (cellIdx >= this.currentLine.length) {
            return false;
        }
        this.cellIndex = cellIdx;
        return true;
    }

    @Override
    public boolean moveNextCell(boolean skipNulls) {
        ++this.cellIndex;
        return this.cellIndex < this.currentLine.length;
    }

    @Override
    public int getCurrentCellIdx() {
        return this.cellIndex;
    }

    @Override
    public String getValue() {
        if (this.currentLine == null) {
            throw new RuntimeException("Current line is unset");
        }
        if (this.cellIndex >= this.currentLine.length) {
            throw new IllegalArgumentException("Unable to get value at column: " + this.cellIndex + ". This line only has " + this.currentLine.length + " elements");
        }
        return this.currentLine[this.cellIndex];
    }

    @Override
    public String getValue(int colNo) {
        this.cellIndex = colNo;
        return this.getValue();
    }

    @Override
    public boolean isDate() {
        return this.isDate(this.cellIndex);
    }

    @Override
    public boolean isDate(int cellNo) {
        String val = this.getValue(cellNo);
        try {
            new SdmxDateImpl(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public SdmxDate getSdmxDate(boolean startOfPeriod) {
        return this.getSdmxDate(this.cellIndex, startOfPeriod);
    }

    @Override
    public SdmxDate getSdmxDate(int colNo, boolean startOfPeriod) {
        String val = this.getValue(colNo);
        if (!ObjectUtil.validString(val)) {
            return null;
        }
        if (!startOfPeriod && val.contains("T") && val.charAt(val.length() - 1) != 'T') {
            startOfPeriod = true;
        }
        Date d1 = DateUtil.formatDate(val, startOfPeriod);
        return new SdmxDateImpl(d1, TIME_FORMAT.DATE_TIME, startOfPeriod);
    }

    @Override
    public Date getDate() {
        return this.getDate(this.cellIndex);
    }

    @Override
    public Date getDate(int colNo) {
        String val = this.getValue(colNo);
        if (!ObjectUtil.validString(val)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat();
        try {
            return df.parse(val);
        }
        catch (ParseException e) {
            throw new SdmxSemmanticException(e, "unable to parse date");
        }
    }

    @Override
    public void reset() {
        if (this.inputStream != null) {
            StreamUtil.closeStream(this.inputStream);
        }
        this.inputStream = this.rdl.getInputStream();
        try {
            this.br = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SdmxException(e, "Could not reset CSV Reader");
        }
        this.sheetIndex = -1;
        this.rowIndex = -1;
        this.cellIndex = -1;
        this.endOfFileReached = false;
    }

    @Override
    public CellReaderEngine createCopy(InputStream is) {
        return new CSVReaderEngine(this.rdl.copy());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean skipEmptyRows() {
        block0: while (true) {
            boolean moveNextRow;
            if (!(moveNextRow = this.moveNextRow(true))) {
                this.endOfFileReached = true;
                return false;
            }
            do {
                boolean moveNextCell;
                if (!(moveNextCell = this.moveNextCell(true))) continue block0;
            } while (!ObjectUtil.validString(this.getValue()));
            break;
        }
        return true;
    }

    @Override
    public boolean atEndOfFile() {
        return this.endOfFileReached;
    }
}

