/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import io.sdmx.api.csv.ColumnReaderEngine;
import io.sdmx.api.csv.DELIMITER;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.format.FormatDetails;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.format.FormatDetailsImpl;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CSVColumnReaderEngineImpl
implements ColumnReaderEngine {
    private static final FormatDetails formatDetails = new FormatDetailsImpl("csv", "csv", "application/vnd.csv", false, new String[0]);
    private ReadableDataLocation rdl;
    private InputStream inputStream;
    private BufferedReader br;
    private String currentString;
    private CSVParser parser;
    private boolean endOfFileReached = false;
    private int startIndex = 0;
    private int pos = 0;
    private List<String> header;
    private String[] currentLine;
    private List<String> currentRow;
    private DELIMITER delimiter;

    public CSVColumnReaderEngineImpl(ReadableDataLocation rdl) {
        this(rdl, DELIMITER.COMMA);
    }

    public CSVColumnReaderEngineImpl(ReadableDataLocation rdl, DELIMITER delimiter) {
        this(rdl, delimiter, null, 0);
    }

    public CSVColumnReaderEngineImpl(ReadableDataLocation rdl, DELIMITER delimiter, List<String> header, int startIndex) {
        if (delimiter == null) {
            delimiter = DELIMITER.COMMA;
        }
        boolean buildHeader = true;
        if (ObjectUtil.validCollection(header)) {
            this.header = Collections.unmodifiableList(new ArrayList<String>(header));
            buildHeader = false;
        }
        this.rdl = rdl;
        this.delimiter = delimiter;
        this.startIndex = startIndex;
        if (buildHeader) {
            ++this.startIndex;
        }
        this.parser = new CSVParserBuilder().withSeparator(delimiter.getDelimiter()).build();
        try {
            this.createReader(buildHeader);
        }
        catch (Exception e) {
            throw new SdmxException(e, "Could not create CSVColumnReaderEngine");
        }
    }

    @Override
    public ColumnReaderEngine copy() {
        return new CSVColumnReaderEngineImpl(this.rdl.copy(), this.delimiter, this.header, this.startIndex);
    }

    @Override
    public FormatDetails getFormatDetails() {
        return formatDetails;
    }

    private void createReader(boolean buildHeader) {
        this.pos = 0;
        this.inputStream = this.rdl.getInputStream();
        this.endOfFileReached = false;
        this.br = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));
        if (buildHeader) {
            this.moveNextRow();
            this.buildHeader();
        }
        for (int i = this.pos; i < this.startIndex; ++i) {
            if (this.readLine() != null) continue;
            this.endOfFileReached = true;
            return;
        }
    }

    private void buildHeader() {
        this.header = this.readRow();
        if (this.header.size() == 0) {
            throw new SdmxException("Can not read CSV Columnar data, no column header row detected");
        }
    }

    @Override
    public List<String> readHeader() {
        return this.header;
    }

    @Override
    public void reset() {
        if (this.inputStream != null) {
            StreamUtil.closeStream(this.inputStream);
        }
        this.createReader(false);
    }

    @Override
    public boolean moveNextRow() {
        this.currentRow = null;
        if (this.endOfFileReached) {
            return false;
        }
        this.currentString = this.readLine();
        if (this.currentString == null) {
            this.endOfFileReached = true;
            return false;
        }
        try {
            this.currentLine = this.parser.parseLine(this.currentString);
        }
        catch (IOException e) {
            throw new SdmxException(e, "Error reading CSV Row: " + this.pos);
        }
        for (String lineItem : this.currentLine) {
            if (!ObjectUtil.validString(lineItem)) continue;
            ++this.pos;
            this.currentRow = Collections.unmodifiableList(Arrays.asList(this.currentLine));
            return true;
        }
        return this.moveNextRow();
    }

    private String readLine() {
        try {
            return this.br.readLine();
        }
        catch (IOException e) {
            throw new SdmxException(e, "Error reading row from stream");
        }
    }

    @Override
    public List<String> readRow() {
        if (this.currentLine == null) {
            return Collections.emptyList();
        }
        return this.currentRow;
    }

    @Override
    public void close() {
        if (this.rdl != null && !this.rdl.isClosed()) {
            this.rdl.close();
        }
    }

    @Override
    public int getPosition() {
        return this.pos;
    }
}

