/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.collection;

import io.sdmx.api.collection.KeyValue;
import io.sdmx.utils.core.collection.CollectionUtil;
import io.sdmx.utils.core.collection.KeyValueImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeyValueUtil {
    public static List<KeyValue> append(List<KeyValue> list, String concept, String ... code) {
        ArrayList<KeyValue> newList = new ArrayList<KeyValue>(list.size() + 1);
        newList.addAll(list);
        newList.add(KeyValueImpl.getInstance(concept, code));
        return newList;
    }

    public static List<KeyValue> append(List<KeyValue> list, Collection<KeyValue> kvs) {
        ArrayList<KeyValue> newList = new ArrayList<KeyValue>(list.size() + kvs.size());
        newList.addAll(list);
        for (KeyValue kv : kvs) {
            newList.add(kv);
        }
        return newList;
    }

    public static Map<String, Set<String>> toMapOfSet(Collection<KeyValue> keyValues) {
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>();
        for (KeyValue kv : keyValues) {
            CollectionUtil.addToMappedSet(returnMap, kv.getConcept(), kv.getCode());
        }
        return returnMap;
    }

    public static List<KeyValue> toKeyValues(String ... kvs) {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        if (kvs != null) {
            for (String kvString : kvs) {
                String[] split = kvString.split(" ", 2);
                String[] splitValues = split[1].split(",");
                returnList.add(KeyValueImpl.getInstance(split[0], splitValues));
            }
        }
        return returnList;
    }
}

