/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.collection;

import io.sdmx.api.collection.KeyValue;
import io.sdmx.utils.core.collection.CollectionUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.object.StringUtil;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;

public class KeyValueImpl
implements KeyValue {
    private static final Map<String, SoftReference<KeyValue>> cache = new ReferenceMap();
    private static final long serialVersionUID = 1L;
    private String code;
    private String concept;
    private List<String> values;
    private transient int hashCode = -1;
    private transient String asString = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyValue getInstance(String id, String ... value) {
        if (value != null && value.length > 1) {
            return new KeyValueImpl(id, value);
        }
        if (value == null || value.length == 0) {
            return new KeyValueImpl(id, value);
        }
        String key = id + ":" + value[0];
        Map<String, SoftReference<KeyValue>> map = cache;
        synchronized (map) {
            SoftReference<KeyValue> softKv = cache.get(key);
            KeyValue returnKv = null;
            if (softKv != null) {
                returnKv = softKv.get();
            }
            if (returnKv == null) {
                returnKv = new KeyValueImpl(id, value);
                softKv = new SoftReference<KeyValue>(returnKv);
                cache.put(key, softKv);
            }
            return returnKv;
        }
    }

    private KeyValueImpl(String id, String ... value) {
        this.concept = StringUtil.manualIntern(id);
        if (value != null && value.length > 0) {
            if (value.length > 1) {
                this.values = Collections.unmodifiableList(CollectionUtil.arrayToList(true, value));
            } else {
                this.code = StringUtil.manualIntern(value[0]);
            }
        }
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public boolean hasMultipleValues() {
        return this.values != null;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getConcept() {
        return this.concept;
    }

    @Override
    public int compareTo(KeyValue that) {
        if (this.concept.equals(that.getConcept())) {
            if (this.code == null && that.getCode() == null) {
                if (this.values == null && that.getValues() == null) {
                    return 0;
                }
                if (this.values == null) {
                    return -1;
                }
                if (that.getValues() == null) {
                    return 1;
                }
                if (this.values.size() > that.getValues().size()) {
                    return 1;
                }
                if (this.values.size() < that.getValues().size()) {
                    return -1;
                }
                for (int i = 0; i < this.values.size(); ++i) {
                    int compareVal = this.values.get(i).compareTo(that.getValues().get(i));
                    if (compareVal == 0) continue;
                    return compareVal;
                }
                return 0;
            }
            if (this.code == null) {
                return -1;
            }
            if (that.getCode() == null) {
                return 1;
            }
            return this.code.compareTo(that.getCode());
        }
        return this.concept.compareTo(that.getConcept());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyValue) {
            KeyValue that = (KeyValue)obj;
            if (!this.getConcept().equals(that.getConcept())) {
                return false;
            }
            if (this.getCode() == null && that.getCode() == null) {
                return ObjectUtil.equivalentCollection(this.getValues(), that.getValues()) && this.hashCode() == that.hashCode();
            }
            if (this.getCode() == null) {
                return false;
            }
            if (that.getCode() == null) {
                return false;
            }
            return this.getCode().equals(that.getCode()) && this.hashCode() == that.hashCode();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String getShortCode() {
        return this.toString();
    }

    public String toString() {
        if (this.asString == null) {
            if (this.code == null) {
                if (this.values == null) {
                    this.asString = this.concept + ":";
                } else {
                    StringBuilder sb = new StringBuilder();
                    String concat = "";
                    for (String str : this.values) {
                        sb.append(concat + str);
                        concat = ", ";
                    }
                    this.asString = this.concept + ":" + sb.toString();
                }
            } else {
                this.asString = this.concept + ":" + this.code;
            }
        }
        return this.asString;
    }
}

