/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.collection;

import io.sdmx.api.notification.Listener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class FiniteMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int lifetimeMills;
    private static int i = 0;
    private Listener<V>[] listeners;
    private Map<Key, Object> lastAccessedMap = new TreeMap<Key, Object>();

    public FiniteMap(int lifeTime, Listener<V> ... listeners) {
        this.lifetimeMills = lifeTime;
        this.listeners = listeners;
        Thread t = new Thread(new CacheReseter());
        t.setDaemon(true);
        t.start();
    }

    public FiniteMap(int lifeTime) {
        this(lifeTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object returnObj = super.get(key);
        if (returnObj != null) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(key);
                this.lastAccessedMap.put(new Key(returnObj), key);
            }
        }
        return returnObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key != null && value != null) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(key);
                this.lastAccessedMap.put(new Key(value), key);
            }
        }
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Map<Key, Object> map = this.lastAccessedMap;
        synchronized (map) {
            this.lastAccessedMap.values().remove(key);
        }
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterMap() {
        HashSet<Key> removeSet = new HashSet<Key>();
        long currentTime = new Date().getTime();
        long evictionTime = currentTime - (long)this.lifetimeMills;
        Map<Key, Object> map = this.lastAccessedMap;
        synchronized (map) {
            for (Key currentKey : this.lastAccessedMap.keySet()) {
                if (currentKey.getTime() >= evictionTime) break;
                removeSet.add(currentKey);
            }
            for (Key currentKey : removeSet) {
                Object o = this.lastAccessedMap.get(currentKey);
                if (this.listeners != null) {
                    for (Listener<V> listener : this.listeners) {
                        listener.invoke(currentKey.value);
                    }
                }
                this.remove(o);
            }
        }
    }

    private class Key
    implements Comparable<Key> {
        private int num;
        private long time;
        private V value;

        Key(V value) {
            this.value = value;
            this.time = new Date().getTime();
            this.num = i++;
        }

        public V getValue() {
            return this.value;
        }

        long getTime() {
            return this.time;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.num == that.num;
            }
            return false;
        }

        public int hashCode() {
            return this.num;
        }

        @Override
        public int compareTo(Key that) {
            return this.num - that.num;
        }
    }

    private class CacheReseter
    implements Runnable {
        boolean isRunning = true;

        private CacheReseter() {
        }

        @Override
        public void run() {
            while (this.isRunning) {
                FiniteMap.this.filterMap();
                try {
                    Thread.sleep(FiniteMap.this.lifetimeMills / 2);
                }
                catch (InterruptedException ie) {
                    this.isRunning = false;
                }
            }
        }
    }
}

