/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.collection;

import io.sdmx.api.notification.Listener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class FiniteList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private int lifetimeMills;
    private static int i = 0;
    private Listener[] listeners;
    private Map<Key, Object> lastAccessedMap = new TreeMap<Key, Object>();

    public FiniteList(int lifeTime, Listener ... listeners) {
        this.lifetimeMills = lifeTime;
        this.listeners = listeners;
        Thread t = new Thread(new CacheReseter());
        t.setDaemon(true);
        t.start();
    }

    public FiniteList(int lifeTime) {
        this(lifeTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object returnObj = super.get(index);
        if (returnObj != null) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(returnObj);
                this.lastAccessedMap.put(new Key(), returnObj);
            }
        }
        return returnObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        boolean b = super.add(e);
        if (b) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(e);
                this.lastAccessedMap.put(new Key(), e);
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object retVal = super.remove(index);
        if (retVal != null) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean retVal = super.remove(o);
        if (retVal) {
            Map<Key, Object> map = this.lastAccessedMap;
            synchronized (map) {
                this.lastAccessedMap.values().remove(o);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterMap() {
        HashSet<Key> removeSet = new HashSet<Key>();
        long currentTime = new Date().getTime();
        long evictionTime = currentTime - (long)this.lifetimeMills;
        Map<Key, Object> map = this.lastAccessedMap;
        synchronized (map) {
            for (Key currentKey : this.lastAccessedMap.keySet()) {
                if (currentKey.getTime() >= evictionTime) break;
                removeSet.add(currentKey);
            }
            for (Key currentKey : removeSet) {
                Object o = this.lastAccessedMap.get(currentKey);
                if (this.listeners != null) {
                    for (Listener listener : this.listeners) {
                        listener.invoke(o);
                    }
                }
                this.remove(o);
            }
        }
    }

    private class Key
    implements Comparable<Key> {
        private int num;
        private long time = new Date().getTime();

        Key() {
            this.num = i++;
        }

        long getTime() {
            return this.time;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.num == that.num;
            }
            return false;
        }

        public int hashCode() {
            return this.num;
        }

        @Override
        public int compareTo(Key that) {
            return this.num - that.num;
        }
    }

    private class CacheReseter
    implements Runnable {
        boolean isRunning = true;

        private CacheReseter() {
        }

        @Override
        public void run() {
            while (this.isRunning) {
                FiniteList.this.filterMap();
                try {
                    Thread.sleep(FiniteList.this.lifetimeMills / 2);
                }
                catch (InterruptedException ie) {
                    this.isRunning = false;
                }
            }
        }
    }
}

