/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.collection;

import io.sdmx.api.collection.KeyValue;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.object.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static final Set<String> EMPTY_STRING_SET = Collections.unmodifiableSet(new HashSet());
    public static final List<String> EMPTY_STRING_LIST = Collections.unmodifiableList(new ArrayList());

    public static Map<String, String> buildMapValues(String ... values) {
        return CollectionUtil.buildMapValues(false, values);
    }

    public static Map<String, String> buildMapValues(boolean preserveOrder, String ... values) {
        LinkedHashMap<String, String> map = preserveOrder ? new LinkedHashMap() : new HashMap();
        for (String currentConceptValue : values) {
            String[] split = currentConceptValue.split(" ", 2);
            if (split.length == 1) {
                map.put(split[0], null);
                continue;
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static Map<String, String> singleMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, value);
        return map;
    }

    public static <T> Set<T> copyToImmutable(Set<T> set) {
        return Collections.unmodifiableSet(new HashSet<T>(set));
    }

    public static <K, V> Map<K, Set<V>> getImmutableMapOfSets(Map<K, Set<V>> map) {
        for (K link : map.keySet()) {
            Set<V> links = map.get(link);
            map.put(link, Collections.unmodifiableSet(links));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<T> getImmutableList(T ... contents) {
        ArrayList<T> list = new ArrayList<T>();
        if (contents != null) {
            for (T item : contents) {
                if (item == null) continue;
                list.add(item);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static <V, T> void mergeMap(Map<V, Set<T>> fromMap, Map<V, Set<T>> toMap) {
        for (V mapKey : fromMap.keySet()) {
            Set<T> refs = toMap.get(mapKey);
            Set<T> fromSet = fromMap.get(mapKey);
            if (fromSet == null) continue;
            if (refs == null) {
                refs = new HashSet<T>();
                toMap.put((Set<T>)mapKey, refs);
            }
            refs.addAll(fromSet);
        }
    }

    public static <V, T> Map<V, Set<T>> copyMap(Map<V, Set<T>> fromMap) {
        HashMap<V, HashSet<T>> toMap = new HashMap<V, HashSet<T>>();
        for (V mapKey : fromMap.keySet()) {
            Set<T> mapped = fromMap.get(mapKey);
            if (mapped == null) {
                toMap.put(mapKey, null);
                continue;
            }
            toMap.put(mapKey, new HashSet<T>(mapped));
        }
        return toMap;
    }

    public static void listToPosition(List<String> compIds, Map<String, Integer> posMap) {
        for (int i = 0; i < compIds.size(); ++i) {
            posMap.put(compIds.get(i), i);
        }
    }

    public static Map<String, Integer> arrayToPosition(String[] arr) {
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        for (int i = 0; i < arr.length; ++i) {
            returnMap.put(arr[i], i);
        }
        return returnMap;
    }

    public static Set<String> arrayToSet(String ... arr) {
        int length = arr != null ? arr.length : 0;
        HashSet<String> returnSet = new HashSet<String>(length);
        if (length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                returnSet.add(arr[i]);
            }
        }
        return returnSet;
    }

    public static List<String> arrayToList(boolean intern, String ... arr) {
        int length = arr != null ? arr.length : 0;
        ArrayList<String> returnList = new ArrayList<String>(length);
        if (length > 0) {
            arr = intern ? StringUtil.manualIntern(arr) : arr;
            for (int i = 0; i < arr.length; ++i) {
                returnList.add(arr[i]);
            }
        }
        return returnList;
    }

    public static String[] positionMapToArray(Map<String, Integer> posMap) {
        String[] returnArray = new String[posMap.size()];
        for (String str : posMap.keySet()) {
            Integer position = posMap.get(str);
            returnArray[position.intValue()] = str;
        }
        return returnArray;
    }

    public static <T> List<T> toList(T ... str) {
        ArrayList<T> list = new ArrayList<T>();
        if (str != null) {
            for (T s : str) {
                list.add(s);
            }
        }
        return list;
    }

    public static int indexInArray(Object[] arr, Object str) {
        int i = 0;
        for (Object obj : arr) {
            if (ObjectUtil.equivalent(obj, str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> void addToCollection(Collection<T> collection, T entry) {
        if (entry != null && collection != null) {
            collection.add(entry);
        }
    }

    public static <V, T> void addToMappedSet(Map<V, Set<T>> map, V key, Set<T> value) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>(value.size());
            map.put((Set<T>)key, set);
        }
        set.addAll(value);
    }

    public static <V, T> void addToMappedSet(Map<V, Set<T>> map, V key, T value) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put((Set<T>)key, set);
        }
        set.add(value);
    }

    public static <V, T> void addToMappedList(Map<V, List<T>> map, V key, T value) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put((List<T>)key, list);
        }
        list.add(value);
    }

    public static <K, T, V> void addToMappedMap(Map<K, Map<T, V>> map, K key, T submapKey, V value) {
        Map<T, V> submap = map.get(key);
        if (submap == null) {
            submap = new HashMap<T, V>();
            map.put(key, submap);
        }
        submap.put(submapKey, value);
    }

    public static Map<String, Set<String>> keyValuesToMap(Set<KeyValue> keyValues) {
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>();
        for (KeyValue kv : keyValues) {
            if (kv.getCode() == null) continue;
            String dimId = kv.getConcept();
            HashSet<String> valueSet = (HashSet<String>)returnMap.get(dimId);
            if (valueSet == null) {
                valueSet = new HashSet<String>();
                returnMap.put(dimId, valueSet);
            }
            valueSet.add(kv.getCode());
        }
        return returnMap;
    }

    public static Map<String, String> keyValuesToFlatMap(Collection<KeyValue> keyValues) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (keyValues != null) {
            for (KeyValue kv : keyValues) {
                if (kv == null || kv.getCode() == null) continue;
                returnMap.put(kv.getConcept(), kv.getCode());
            }
        }
        return returnMap;
    }

    public static Set<Object> toSet(Collection<?> collection) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object obj : collection) {
            set.add(obj);
        }
        return set;
    }

    public static String[] toArray(Collection<String> coll) {
        if (coll == null) {
            return new String[0];
        }
        String[] arr = new String[coll.size()];
        coll.toArray(arr);
        return arr;
    }

    public static String collectionToString(Collection<? extends Object> array, String join, String replaceMissing) {
        StringBuilder sb = new StringBuilder();
        String concat = "";
        if (array != null) {
            for (Object object : array) {
                String asString;
                String string = asString = object == null ? replaceMissing : object.toString();
                if (asString == null) {
                    asString = "";
                }
                sb.append(concat + object.toString());
                concat = join;
            }
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] array, String replaceMissing) {
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (Object arrayItem : array) {
            String asString;
            String string = asString = arrayItem == null ? replaceMissing : arrayItem.toString();
            if (asString == null) {
                asString = "";
            }
            sb.append(concat + arrayItem.toString());
            concat = ":";
        }
        return sb.toString();
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        HashSet<T> union = new HashSet<T>(coll1);
        union.addAll(coll2);
        HashSet<T> intersection = new HashSet<T>(coll1);
        intersection.retainAll(coll2);
        HashSet<T> result = union;
        result.removeAll(intersection);
        return result;
    }

    @SafeVarargs
    public static <E> void removeAll(Collection<E> toRemoveFrom, Collection<E> ... toRemove) {
        for (Collection<E> items : toRemove) {
            toRemoveFrom.removeAll(items);
        }
    }

    public static <E> boolean isSame(Collection<E> collectionOne, Collection<E> collectionTwo) {
        Object[] objArrTwo;
        Object[] objArrOne = collectionOne.toArray();
        if (objArrOne.length != (objArrTwo = collectionTwo.toArray()).length) {
            return false;
        }
        for (int i = 0; i < objArrOne.length; ++i) {
            if (objArrOne[i].equals(objArrTwo[i])) continue;
            return false;
        }
        return true;
    }

    public static int getTotalCollectionSize(Collection<?> ... collections) {
        int size = 0;
        if (collections != null) {
            for (Collection<?> collection : collections) {
                size += collection.size();
            }
        }
        return size;
    }

    public static int[] getListPositions(List<?> list1, List<?> list2) {
        int[] positions = new int[list1.size()];
        int i = 0;
        for (Object item : list1) {
            positions[i] = list2.lastIndexOf(item);
            ++i;
        }
        return positions;
    }

    public static int getIntersectionSize(Set<?> set1, Set<?> set2) {
        if (!ObjectUtil.validCollection(set1)) {
            return 0;
        }
        if (!ObjectUtil.validCollection(set2)) {
            return 0;
        }
        int intersection = 0;
        for (Object o : set1) {
            if (!set2.contains(o)) continue;
            ++intersection;
        }
        return intersection;
    }

    public static boolean containsAny(Set<?> set1, Collection<?> collection2) {
        if (!ObjectUtil.validCollection(set1)) {
            return false;
        }
        if (!ObjectUtil.validCollection(collection2)) {
            return false;
        }
        for (Object o : collection2) {
            if (!set1.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static <T> Collector<T, ?, T> toSingleton() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                throw new IllegalStateException();
            }
            return list.get(0);
        });
    }

    public static <T> String join(String join, String replaceNullString, Collection<String> collection) {
        return CollectionUtil.join(join, replaceNullString, CollectionUtil.toArray(collection));
    }

    public static <T> String join(String join, String replaceNullString, T ... str) {
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            String concat = "";
            for (T s : str) {
                if (s == null) {
                    if (replaceNullString == null) continue;
                    sb.append(concat + replaceNullString);
                } else {
                    sb.append(concat + s.toString());
                }
                concat = join;
            }
        }
        return sb.toString();
    }
}

