/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.audit;

import io.sdmx.api.audit.IAuditEventManager;
import io.sdmx.api.audit.IFusionAuditEvent;
import io.sdmx.api.process.IProcess;
import io.sdmx.api.process.IProcessWithResponse;
import io.sdmx.api.security.ISecureThread;
import io.sdmx.utils.core.application.SingletonStore;
import io.sdmx.utils.core.security.FusionSecurityContext;

public class AuditUtil {
    private static IAuditEventManager auditEventManager;

    public static void setAuditEventManager(IAuditEventManager auditEventManager) {
        AuditUtil.auditEventManager = auditEventManager;
    }

    public static String startSettingsAuditEvent(String processId, String target, ACTION action, IProcess procss) {
        return AuditUtil.startAuditEvent(processId, "SETTINGS", () -> {
            AuditUtil.addAuditProperty("Target", target);
            AuditUtil.addAuditProperty("Action", (Object)action);
            procss.runProcess();
        });
    }

    public static String startOperationEvent(String processId, String action, IProcess auditProcss) {
        return AuditUtil.startAuditEvent(processId, "OPERATION", () -> {
            AuditUtil.addAuditProperty("Action", action);
            auditProcss.runProcess();
        });
    }

    public static String prepareAudit(String processId, String eventType, IProcess auditProcss) {
        if (auditEventManager != null) {
            return auditEventManager.prepareAudit(processId, eventType, auditProcss);
        }
        auditProcss.runProcess();
        return null;
    }

    public static String startAuditEvent(String processId, String eventType, IProcess auditProcss) {
        if (auditEventManager != null) {
            return auditEventManager.startAuditEvent(processId, eventType, auditProcss);
        }
        auditProcss.runProcess();
        return null;
    }

    public static String startAuditEvent(String processId, String eventType, String parentId, IProcess auditProcss) {
        if (auditEventManager != null) {
            return auditEventManager.startAuditEvent(processId, eventType, parentId, auditProcss);
        }
        auditProcss.runProcess();
        return null;
    }

    public static <T> T startAuditEventWithResponse(String processId, String eventType, IProcessWithResponse<T> auditProcss) {
        if (auditEventManager != null) {
            return auditEventManager.startAuditEventWithResponse(processId, eventType, auditProcss);
        }
        return auditProcss.runProcess();
    }

    public static String startNewThread(String processId, String eventType, boolean copyThreadLocal, IProcess process) {
        if (auditEventManager != null) {
            return auditEventManager.startNewThread(processId, eventType, copyThreadLocal, process);
        }
        ISecureThread thread = FusionSecurityContext.CTX().createSecureThread(copyThreadLocal);
        thread.runProcess(process);
        return null;
    }

    public static void addAuditProperty(String propertyId, Object propertyValue) {
        if (auditEventManager != null && propertyValue != null) {
            auditEventManager.addAuditProperty(propertyId, propertyValue);
        }
    }

    public static IFusionAuditEvent getCurrentAudit() {
        if (auditEventManager != null) {
            return auditEventManager.getCurrentAudit();
        }
        return null;
    }

    public static String getCurrentAuditId() {
        if (auditEventManager != null) {
            return auditEventManager.getCurrentAuditId();
        }
        return null;
    }

    static {
        SingletonStore.registerInterest(IAuditEventManager.class, manager -> {
            auditEventManager = manager;
        });
    }

    public static enum ACTION {
        ADD,
        EDIT,
        DELETE,
        VIEW;

    }
}

