/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.application;

import io.sdmx.utils.core.thread.ThreadLocalUtil;

public class SystemSecurity {
    private static SystemSecurity INSTANCE = new SystemSecurity();
    private static boolean isApplicationStarted;

    private SystemSecurity() {
    }

    public static void setApplicationStarted(boolean bool) {
        isApplicationStarted = bool;
    }

    public static boolean isSystemProcess() {
        if (!isApplicationStarted) {
            return true;
        }
        SYSPROC sysproc = (SYSPROC)ThreadLocalUtil.retrieveFromThread(SYSPROC.class.getName());
        return sysproc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemProcess() {
        SystemSecurity systemSecurity = INSTANCE;
        synchronized (systemSecurity) {
            SYSPROC sysproc = (SYSPROC)ThreadLocalUtil.retrieveFromThread(SYSPROC.class.getName());
            if (sysproc == null) {
                sysproc = INSTANCE.createSystemProcess();
                ThreadLocalUtil.storeOnThread(SYSPROC.class.getName(), sysproc);
            }
            sysproc.processCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSystemProcess() {
        SystemSecurity systemSecurity = INSTANCE;
        synchronized (systemSecurity) {
            SYSPROC sysproc = (SYSPROC)ThreadLocalUtil.retrieveFromThread(SYSPROC.class.getName());
            if (sysproc != null) {
                sysproc.processCount--;
                if (sysproc.processCount <= 0) {
                    ThreadLocalUtil.clearFromThread(SYSPROC.class.getName());
                }
            }
        }
    }

    private SYSPROC createSystemProcess() {
        return new SYSPROC();
    }

    private class SYSPROC {
        private int processCount = 0;

        private SYSPROC() {
        }
    }
}

