/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.application;

import io.sdmx.api.application.ISystemInformation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;

public class SystemInformation
implements ISystemInformation {
    private static final SystemInformation INSTANCE = new SystemInformation();
    private String machineIdentifier;
    private String vmIdentifier;
    private final long launchDate = System.currentTimeMillis();

    public static SystemInformation INSTANCE() {
        return INSTANCE;
    }

    private SystemInformation() {
        this.vmIdentifier = new VMID().toString();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.machineIdentifier = addr.toString();
        }
        catch (UnknownHostException e) {
            this.machineIdentifier = "UNKNOWN";
        }
    }

    @Override
    public long getLaunchDate() {
        return this.launchDate;
    }

    @Override
    public String getMachineIdentifier() {
        return this.machineIdentifier;
    }

    @Override
    public String getVmIdentifier() {
        return this.vmIdentifier;
    }
}

