/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.application;

import io.sdmx.api.application.ISingletonContainer;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.utils.core.application.ISingletonAware;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SingletonStore {
    private static ISingletonContainer container;
    private static Map<Class, Object> localInstanceStore;
    private static Map<Class<?>, List<ISingletonAware<?>>> futureStore;

    public static void clearState() {
        container = null;
        localInstanceStore = new HashMap<Class, Object>();
    }

    public static void setContainer(ISingletonContainer container) {
        SingletonStore.container = container;
        SingletonStore.checkFutures();
    }

    public static void registerInstance(Object instance) {
        localInstanceStore.put(instance.getClass(), instance);
        for (Class<?> iclaz : instance.getClass().getInterfaces()) {
            localInstanceStore.put(iclaz, instance);
        }
        SingletonStore.checkFutures();
    }

    public static void checkFutures() {
        HashSet removeKeys = null;
        for (Class<?> key : futureStore.keySet()) {
            List<ISingletonAware<?>> sis;
            Object o = SingletonStore.getSingleton(key, false);
            if (o == null || (sis = futureStore.get(key)) == null) continue;
            try {
                for (ISingletonAware<?> si : sis) {
                    for (Method m : ISingletonAware.class.getMethods()) {
                        if (!m.getName().equals("setSingleton")) continue;
                        try {
                            m.invoke(si, o);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (removeKeys == null) {
                    removeKeys = new HashSet(10);
                }
                removeKeys.add(key);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (removeKeys != null) {
            futureStore.keySet().removeAll(removeKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void registerInterest(Class<T> type, ISingletonAware<T> future) {
        T singleton = SingletonStore.getSingleton(type, false);
        if (singleton != null) {
            future.setSingleton(singleton);
        } else {
            Map<Class<?>, List<ISingletonAware<?>>> map = futureStore;
            synchronized (map) {
                List<ISingletonAware<?>> futures = futureStore.get(type);
                if (futures == null) {
                    futures = new ArrayList();
                    futureStore.put(type, futures);
                }
                futures.add(future);
            }
        }
    }

    public static <T> T getSingleton(Class<T> type) {
        return SingletonStore.getSingleton(type, true);
    }

    public static <T> T getSingleton(Class<T> type, boolean required) {
        Object o = localInstanceStore.get(type);
        if (o != null) {
            return (T)o;
        }
        if (container == null) {
            return null;
        }
        T singleton = container.getSingleton(type);
        if (singleton == null && required) {
            throw new SdmxException("Missing required instance of type:" + type);
        }
        return singleton;
    }

    public static <T> T getSingleton(Class<T> type, String name, boolean required) {
        if (container == null) {
            return null;
        }
        T singleton = container.getSingleton(type, name);
        if (singleton == null && required) {
            throw new SdmxException("Missing required instance of type:" + type);
        }
        return singleton;
    }

    static {
        localInstanceStore = new HashMap<Class, Object>();
        futureStore = new ConcurrentHashMap();
    }
}

