/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.application;

import io.sdmx.api.application.IFusionContainer;
import io.sdmx.api.singleton.IFusionSingleton;
import io.sdmx.utils.core.collection.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FusionBeanStore {
    private static IFusionContainer container;
    private static Map<Class, Set<Object>> localInstanceStore;

    public static void clearState() {
        Collection<IFusionSingleton> beans = null;
        try {
            beans = FusionBeanStore.getBeans(IFusionSingleton.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (beans != null) {
            for (IFusionSingleton aFusionSingleton : beans) {
                aFusionSingleton.destroyInstance();
            }
        }
        container = null;
        localInstanceStore = new HashMap<Class, Set<Object>>();
    }

    public static void setContainer(IFusionContainer container) {
        FusionBeanStore.container = container;
    }

    public static void registerInstance(Object instance) {
        for (Class<?> claz = instance.getClass(); claz != null && claz != Object.class; claz = claz.getSuperclass()) {
            FusionBeanStore.putInstance(claz, instance);
            for (Class<?> iclaz : claz.getInterfaces()) {
                FusionBeanStore.putInterface(iclaz, instance);
            }
        }
    }

    private static void putInterface(Class claz, Object instance) {
        FusionBeanStore.putInstance(claz, instance);
        for (Class<?> iclaz : claz.getInterfaces()) {
            FusionBeanStore.putInterface(iclaz, instance);
        }
    }

    private static void putInstance(Class claz, Object instance) {
        CollectionUtil.addToMappedSet(localInstanceStore, claz, instance);
    }

    public static <T> Collection<T> getBeans(Class<T> type) {
        Set<Object> set1 = localInstanceStore.get(type);
        Collection<T> set2 = null;
        if (container != null) {
            set2 = container.getBeans(type);
        }
        if (set1 != null && set2 != null) {
            HashSet<Object> returnSet = new HashSet<Object>();
            returnSet.addAll(set1);
            returnSet.addAll(set2);
            return returnSet;
        }
        if (set1 != null) {
            return Collections.unmodifiableSet(set1);
        }
        if (set2 != null) {
            return Collections.unmodifiableCollection(set2);
        }
        return Collections.emptySet();
    }

    static {
        localInstanceStore = new HashMap<Class, Set<Object>>();
    }
}

