/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.application;

import io.sdmx.api.application.APIManager;
import io.sdmx.api.settings.PropertiesAwareManager;
import io.sdmx.utils.core.version.Version;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class APIManagerImpl
implements APIManager,
PropertiesAwareManager {
    private static Logger LOG = LoggerFactory.getLogger(APIManagerImpl.class);
    private Map<String, Version> versionMap = new HashMap<String, Version>();

    public APIManagerImpl() {
        Properties props = System.getProperties();
        this.analyseProperties(props);
    }

    @Override
    public void analyseProperties(Properties props) {
        if (props != null) {
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = propNames.nextElement().toString();
                if (!propName.startsWith("api.version")) continue;
                String keyName = propName.substring("api.version".length() + 1);
                this.setVersion(keyName, props.getProperty(propName));
            }
        }
    }

    @Override
    public void setVersion(String APIKey, String version) {
        LOG.info("API '" + APIKey + "' set to version:" + version);
        if (version != null) {
            this.versionMap.put(APIKey, new Version(version));
        }
    }

    @Override
    public boolean hasVersion(String APIKey) {
        return this.versionMap.containsKey(APIKey);
    }

    @Override
    public Version getVersion(String APIKey) {
        return this.versionMap.get(APIKey);
    }
}

