/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.fmrcl.util;

import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.ZipUtil;
import io.sdmx.utils.core.io.FileUtil;
import io.sdmx.utils.core.io.ReadableDataLocationTmp;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtil {
    private static Logger LOG = LoggerFactory.getLogger(PathUtil.class);

    public static Path getHomeDir(String productName, String JVMOverrideArg) {
        String homeDirOverride = System.getProperty(JVMOverrideArg);
        LOG.debug(JVMOverrideArg + "=" + homeDirOverride);
        if (ObjectUtil.validString(homeDirOverride)) {
            LOG.info("User specified " + productName + " Home Directory of " + homeDirOverride);
            Path specifiedHomeDir = Paths.get(homeDirOverride, new String[0]);
            PathUtil.ensureDirectory(specifiedHomeDir, true);
            LOG.info("Home Directory =" + specifiedHomeDir);
            return specifiedHomeDir;
        }
        String userHome = System.getProperty("user.home");
        if (ObjectUtil.validString(userHome)) {
            LOG.info("userHome =" + userHome);
            Path aPath = Paths.get(userHome, "MetadataTechnology", productName);
            try {
                PathUtil.ensureDirectory(aPath, true);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage());
            }
        }
        throw new RuntimeException("Please specify '" + JVMOverrideArg + "' Java property");
    }

    public static List<ReadableDataLocation> upzip(Path path) {
        List<ReadableDataLocation> unzipped;
        ReadableDataLocationTmp rdl = new ReadableDataLocationTmp(path);
        if (ZipUtil.isAZip(rdl)) {
            try {
                unzipped = ZipUtil.unzipFiles(rdl);
            }
            finally {
                rdl.close();
            }
        } else {
            unzipped = new ArrayList<ReadableDataLocation>();
            unzipped.add(rdl);
        }
        return unzipped;
    }

    public static Path ensureDirectory(Path p, boolean ensureWritable) {
        if (Files.notExists(p, new LinkOption[0])) {
            try {
                LOG.debug("createDirectories =" + p);
                Files.createDirectories(p, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create specified directory: '" + p.toString() + "'");
            }
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new RuntimeException("Expected directory is not a directory: " + p.toString() + "'");
        }
        if (ensureWritable && !Files.isWritable(p)) {
            throw new RuntimeException("Directory is not writeable. '" + p.toString() + "'");
        }
        return p;
    }

    public static Long getModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            System.err.println("Cannot get the last modified time - " + e);
            return null;
        }
    }

    public static Path createDir(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            FileUtil.ensureDirectoryExists(path.toString());
        }
        return path;
    }

    public static void move(Path from, Path to) {
        try {
            Files.deleteIfExists(to);
            Files.move(from, to, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Path path) {
        try (InputStream inputStream = PathUtil.toStream(path);){
            byte[] byArray = StreamUtil.toByteArray(inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream toStream(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Can not read file as it does not exist '" + path.toString() + "'");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Illegal attempt to read directory as a file '" + path.toString() + "'");
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void replaceFileContents(Path p, String newContents, boolean createBck) {
        if (createBck) {
            Path moveTo = p.getParent().resolve(p.toFile().getName() + ".bck");
            try {
                Files.deleteIfExists(moveTo);
                Files.move(p, moveTo, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        PathUtil.writeFile(p, newContents.getBytes(), false);
    }

    public static void writeFile(Path p, byte[] bytes, boolean zip) {
        OutputStream out = PathUtil.getOutputStream(p, zip);
        StreamUtil.copyStream(new BufferedInputStream(new ByteArrayInputStream(bytes)), out, true);
    }

    public static OutputStream getOutputStream(Path p, boolean zip) {
        try {
            String fileName = p.getFileName().toString();
            if (zip) {
                String zipFileName = fileName;
                if (!zipFileName.endsWith(".zip")) {
                    if (zipFileName.contains(".")) {
                        zipFileName = zipFileName.substring(0, zipFileName.lastIndexOf("."));
                    }
                    zipFileName = zipFileName + ".zip";
                }
                p = p.getParent().resolve(zipFileName);
            }
            PathUtil.createNewFile(p);
            OutputStream out = Files.newOutputStream(p, new OpenOption[0]);
            if (zip) {
                ZipOutputStream zout = new ZipOutputStream(out);
                zout.putNextEntry(new ZipEntry(fileName));
                out = zout;
            }
            return new BufferedOutputStream(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(Path p, ReadableDataLocation rdl, boolean zip) {
        PathUtil.writeFile(p, rdl.getInputStream(), zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Path p, InputStream stream, boolean zip) {
        try {
            OutputStream out = PathUtil.getOutputStream(p, zip);
            StreamUtil.copyStream(stream, out, true);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(stream);
            throw throwable;
        }
        StreamUtil.closeStream(stream);
    }

    public static Path createNewFile(Path p) {
        try {
            PathUtil.ensureDirectory(p.getParent(), true);
            Files.deleteIfExists(p);
            Files.createFile(p, new FileAttribute[0]);
            return p;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFolder(final Path source, OutputStream out) {
        try (final ZipOutputStream zos = new ZipOutputStream(out);){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    try (FileInputStream fis = new FileInputStream(file.toFile());){
                        int len;
                        Path targetFile = source.relativize(file);
                        zos.putNextEntry(new ZipEntry(targetFile.toString()));
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        LOG.debug("Zip file : %s%n", (Object)file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOG.error("Unable to zip : %s%n%s%n", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzipFolder(Path sourceFile, Path targetFolder) {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(sourceFile.toFile()));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                Path newUnzipPath = PathUtil.zipSlipVulnerabilityProtect(zipEntry, targetFolder);
                LOG.debug("Unzip to " + newUnzipPath.toString());
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator)) {
                    isDirectory = true;
                }
                if (isDirectory) {
                    PathUtil.ensureDirectory(newUnzipPath, true);
                } else {
                    PathUtil.createNewFile(newUnzipPath);
                    Files.copy(zipInputStream, newUnzipPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path zipSlipVulnerabilityProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path dirResolved = targetDir.resolve(zipEntry.getName());
        LOG.debug("Normalise Path" + dirResolved);
        Path normalizePath = dirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Invalid zip: " + zipEntry.getName());
        }
        return normalizePath;
    }
}

