/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.fmrcl.util;

import io.sdmx.fmrcl.util.PathUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathFolder {
    private Path folder;
    private Map<String, PathFolder> subfolders = new HashMap<String, PathFolder>();
    private List<Path> files = new ArrayList<Path>();

    public PathFolder(Path folder, Long updatedSince, boolean includeEmptyFolders) {
        this.folder = folder;
        if (Files.exists(folder, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                for (Path path : stream) {
                    Long lastModified;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        PathFolder subfolder = new PathFolder(path, updatedSince, includeEmptyFolders);
                        if (subfolder.files.size() <= 0 && subfolder.subfolders.size() <= 0 && (subfolder.files.size() != 0 || !includeEmptyFolders)) continue;
                        this.subfolders.put(subfolder.getFolderName(), subfolder);
                        continue;
                    }
                    if (updatedSince != null && (lastModified = PathUtil.getModifiedTime(path)) != null && lastModified < updatedSince) continue;
                    this.files.add(path);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading folder: " + this.getFolderName(), e);
            }
        }
        this.subfolders = Collections.unmodifiableMap(this.subfolders);
        this.files = Collections.unmodifiableList(this.files);
    }

    public Set<String> getFileNames() {
        return this.getFiles().stream().map(e -> e.getFileName().toString()).collect(Collectors.toSet());
    }

    public Path getFolder() {
        return this.folder;
    }

    public String getFolderName() {
        return this.folder.getFileName().toString();
    }

    public Set<String> getSubfolderNames() {
        return this.subfolders.keySet();
    }

    public PathFolder getSubfolder(String folderName) {
        return this.subfolders.get(folderName);
    }

    public Collection<PathFolder> getSubfolders() {
        return this.subfolders.values();
    }

    public List<Path> getFiles() {
        return this.files;
    }

    public void deleteContents(boolean includeFolder) {
        for (PathFolder folder : this.getSubfolders()) {
            folder.deleteContents(true);
        }
        for (Path file : this.files) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (includeFolder) {
            try {
                Files.deleteIfExists(this.folder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void keep(Set<Path> paths) {
        for (PathFolder pathFolder : this.getSubfolders()) {
            if (paths.contains(pathFolder.getFolder())) continue;
            pathFolder.keep(paths);
        }
        ArrayList<Path> newFiles = new ArrayList<Path>();
        for (Path file : this.files) {
            if (!paths.contains(file)) {
                try {
                    Files.deleteIfExists(file);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            newFiles.add(file);
        }
        this.files = newFiles;
        if (this.files.size() == 0 && this.subfolders.size() == 0) {
            try {
                Files.deleteIfExists(this.folder);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

