/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.fmrcl.manager;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.fmrcl.util.PathUtil;
import io.sdmx.utils.http.api.model.IHTTPResponse;
import io.sdmx.utils.http.broker.RestMessageBroker;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureBackupManager {
    private static final Logger LOG = LoggerFactory.getLogger(StructureBackupManager.class);

    public static void createBackup(Path rootFolder, String registryURL, String username, String password, boolean usingV10) {
        LOG.info("Start structure backup");
        RestMessageBroker.storeGlobalAuthorization(username, password);
        if (!registryURL.endsWith("/")) {
            registryURL = registryURL + "/";
        }
        try {
            Path structureFolder = PathUtil.createDir(rootFolder.resolve("structures"));
            String structureQuery = registryURL + "ws/public/sdmxapi/rest/structure/all/all/all?format=fusion-json";
            if (!usingV10) {
                structureQuery = structureQuery + "&detail=raw";
            }
            StructureBackupManager.sendMessage(structureQuery, structureFolder, "structures", true);
            JSONArray json = StructureBackupManager.getTransactions(registryURL, structureFolder);
            StructureBackupManager.walkTransactions(registryURL, json, structureFolder);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    private static JSONArray getTransactions(String registryURL, Path structureFolder) throws JSONException {
        byte[] bytes = StructureBackupManager.sendMessage(registryURL + "ws/registry/tx/searchTransactions", structureFolder, "transactions.json");
        return new JSONArray(new String(bytes));
    }

    private static void walkTransactions(String registryURL, JSONArray json, Path structureFolder) throws JSONException {
        for (int i = 0; i < json.length(); ++i) {
            int txId = -1;
            try {
                JSONObject tx = json.getJSONObject(i);
                txId = tx.getInt("Id");
                LOG.info("Backup transaction: " + txId);
                Path txFolder = PathUtil.ensureDirectory(structureFolder.resolve(Integer.toString(txId)), true);
                StructureBackupManager.getTransactionAudit(registryURL, txId, txFolder);
                StructureBackupManager.getTransactionsStructures(registryURL, txId, txFolder);
                continue;
            }
            catch (Throwable th) {
                LOG.error(th.getMessage(), th);
                throw new SdmxException("Transaction backup failed for transaction #" + txId);
            }
        }
    }

    private static void getTransactionAudit(String registryURL, int txId, Path txFolder) throws JSONException {
        StructureBackupManager.sendMessage(registryURL + "ws/secure/audit/getDetailsByTransactionId/?txId=" + txId, txFolder, "audit.json");
    }

    private static void getTransactionsStructures(String registryURL, int txId, Path txFolder) throws JSONException {
        StructureBackupManager.sendMessage(registryURL + "ws/registry/tx/transactions?txId=" + txId, txFolder, "structures");
    }

    private static byte[] sendMessage(String url, Path folderName, String fileName) {
        return StructureBackupManager.sendMessage(url, folderName, fileName, false);
    }

    private static byte[] sendMessage(String url, Path folderName, String fileName, boolean failOnError) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RestMessageBroker.setResponseTimeout(21600);
        RestMessageBroker.setConnectTimeout(21600);
        IHTTPResponse response = RestMessageBroker.sendMessage(bos, url);
        if (failOnError && response.getStatus() >= 400 && response.getStatus() <= 600) {
            System.out.println("Error! HTTP response: " + response.getStatus() + " requesting url: " + url);
            System.exit(0);
        }
        byte[] bytes = bos.toByteArray();
        PathUtil.writeFile(folderName.resolve(fileName), bytes, fileName.equals("structures"));
        return bytes;
    }

    public static String obtainVersionInfo(String url) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RestMessageBroker.setResponseTimeout(21600);
        RestMessageBroker.setConnectTimeout(21600);
        IHTTPResponse response = RestMessageBroker.sendMessage(bos, url);
        if (response.getStatus() >= 400 && response.getStatus() <= 600) {
            return null;
        }
        byte[] bytes = bos.toByteArray();
        try {
            JSONObject jo = new JSONObject(new String(bytes));
            String version = jo.getString("Version");
            int firstDot = version.indexOf(".");
            if (firstDot == -1) {
                return version;
            }
            return version.substring(0, firstDot);
        }
        catch (Exception e) {
            return null;
        }
    }
}

