/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.fmrcl.main;

import io.sdmx.fmrcl.manager.StructureBackupManager;
import io.sdmx.fmrcl.util.PathFolder;
import io.sdmx.fmrcl.util.PathUtil;
import io.sdmx.utils.core.date.DateUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMRCL {
    private static final Logger LOG = LoggerFactory.getLogger(FMRCL.class);

    public static void main(String[] args) throws IOException {
        new FMRCL().run(args);
    }

    public FMRCL() throws IOException {
        this.printVersion();
    }

    private void run(String[] args) throws IOException {
        Options opts = new Options();
        opts.addOption(Option.builder("u").argName("username").desc("Fusion Registry username of user with administrative permissions").hasArg(true).required().build());
        opts.addOption(Option.builder("p").argName("password").desc("Fusion Registry password for username").hasArg(true).required().build());
        opts.addOption(Option.builder("o").argName("output").desc("Output Folder").hasArg(true).required().build());
        opts.addOption(Option.builder("url").argName("URL").desc("Fusion Registry URL").hasArg(true).required().build());
        opts.addOption(Option.builder("v").argName("version").desc("Fusion Registry version").hasArg(true).build());
        CommandLine cl = this.buildCommandLine(opts, args);
        String backupFolderPath = cl.getOptionValue("o");
        String registryURL = cl.getOptionValue("url");
        String username = cl.getOptionValue("u");
        String password = cl.getOptionValue("p");
        Path p = Paths.get(backupFolderPath, new String[0]);
        Path rootFolder = PathUtil.ensureDirectory(p, true);
        boolean usingV10 = this.determineRegistryMajorVersion(cl, registryURL);
        PathFolder folder = new PathFolder(rootFolder, null, true);
        if (ObjectUtil.validCollection(folder.getFiles()) || ObjectUtil.validCollection(folder.getSubfolders())) {
            LOG.error("Please ensure backup folder is empty");
            System.exit(1);
        }
        LOG.info("Creating Backup from Registry: " + registryURL);
        LOG.info("Creating Backup in folder: " + rootFolder.toAbsolutePath().toString());
        try {
            StructureBackupManager.createBackup(rootFolder, registryURL, username, password, usingV10);
            LOG.info("Creating Backup complete:  " + DateUtil.getDateTimeStringNow());
        }
        catch (Throwable th) {
            LOG.error("BACKUP FAILED: " + th.getMessage());
        }
    }

    public CommandLine buildCommandLine(Options opts, String[] args) throws IOException {
        DefaultParser parser = new DefaultParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(opts, args);
        }
        catch (Throwable th) {
            this.printHelp(opts, th.getMessage());
            System.exit(-1);
        }
        if (cl.hasOption("h")) {
            this.printHelp(opts, "HELP MENU");
            System.exit(-1);
        }
        return cl;
    }

    private void printVersion() throws IOException {
        Properties p = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream("build.info");
        if (is != null) {
            p.load(is);
            String version = p.getProperty("version");
            String buildDate = p.getProperty("buildDate");
            LOG.info("Launching FMRCL: v" + version + " Build Date: " + buildDate);
        }
    }

    private void printHelp(Options opts, String missingArg) {
        System.err.println(missingArg);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("compile", opts);
    }

    private boolean determineRegistryMajorVersion(CommandLine cl, String registryURL) {
        String versionInfo = cl.getOptionValue("v");
        if (versionInfo == null || versionInfo.equals("")) {
            LOG.info("Obtaining version information from target Registry");
            versionInfo = StructureBackupManager.obtainVersionInfo(registryURL + "/ws/fusion/info/product");
            if (versionInfo == null) {
                LOG.error("Unable to determine version information from Registry 'info' service.  You must supply a '-V' parameter to run this tool");
                System.exit(1);
            }
            LOG.info("Registry is of major version: " + versionInfo);
        } else {
            LOG.info("Registry Version specified as: " + versionInfo);
        }
        boolean usingV10 = false;
        try {
            int verNum = Integer.parseInt(versionInfo);
            if (verNum < 10) {
                LOG.error("This tool may not be run against a Fusion Registry where the version is less than 10");
                System.exit(1);
            }
            usingV10 = verNum == 10;
        }
        catch (NumberFormatException ex) {
            LOG.error("Illegal version specified '" + versionInfo + "'. Please specify the major version of the Registry as an integer. E.g. 11");
            System.exit(1);
        }
        return usingV10;
    }
}

