/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.security;

import io.sdmx.api.process.IProcess;
import io.sdmx.api.security.ISecureThread;
import io.sdmx.api.security.SecurityDetails;
import java.util.Collections;
import java.util.Set;

public interface ISecurityContextHolder {
    default public String getSanitisedUserName() {
        SecurityDetails sd = this.getSecurityDetails();
        if (sd == null) {
            return null;
        }
        String retValue = sd.getUsername();
        if (retValue == null) {
            return null;
        }
        retValue = retValue.replaceAll("[^\\w\\*@_\\$]", "_");
        return retValue;
    }

    default public Set<String> getCurrentUserGroups() {
        SecurityDetails sd = this.getSecurityDetails();
        if (sd == null) {
            return Collections.emptySet();
        }
        return sd.getRoles();
    }

    public SecurityDetails getSecurityDetails();

    default public boolean hasCurrentUser() {
        return this.getSecurityDetails() != null;
    }

    public boolean isAuthenticated();

    public ISecureThread createSecureThread(boolean var1);

    public void runAsRoot(IProcess var1);

    public void runAsUser(SecurityDetails var1, IProcess var2);
}

