/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.security;

import io.sdmx.api.exception.SdmxUnauthorisedException;
import io.sdmx.api.security.ISecurityAdminFunction;

public interface ISecurityAdminAuthorisationManager {
    default public boolean isAuthorised(ISecurityAdminFunction adminFunction) {
        if (adminFunction == null) {
            throw new IllegalArgumentException("Admin Function required");
        }
        return this.isAuthorised(adminFunction.getId());
    }

    public boolean isAuthorised(String var1);

    default public void authorise(String adminFunctionId) throws SdmxUnauthorisedException {
        if (!this.isAuthorised(adminFunctionId)) {
            throw new SdmxUnauthorisedException("unauthorised");
        }
    }

    default public void authorise(ISecurityAdminFunction adminFunction) throws SdmxUnauthorisedException {
        if (adminFunction == null) {
            throw new IllegalArgumentException("Admin Function required");
        }
        this.authorise(adminFunction.getId());
    }
}

