/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.exception;

import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.ISdmxException;
import io.sdmx.api.exception.SDMX_ERROR_CODE;
import io.sdmx.api.exception.SdmxNoResultsException;
import io.sdmx.api.lang.MessageResolver;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdmxException
extends RuntimeException
implements ISdmxException {
    private static final Logger LOG = LoggerFactory.getLogger(SdmxException.class);
    private static final String DISABLE_EXCEPTIONS = "DISABLE_EXCEPTIONS";
    private static final long serialVersionUID = 7230038232116051945L;
    private static MessageResolver messageResolver = null;
    private ExceptionCode code;
    private String codeStr;
    private Object[] args;
    private final Throwable th;
    private SDMX_ERROR_CODE errorCode = SDMX_ERROR_CODE.INTERNAL_SERVER_ERROR;
    private static final LocalObjectStore localObjectStore = new LocalObjectStore();

    public static boolean isDisabledExceptionTrace() {
        return ((Map)localObjectStore.get()).containsKey(DISABLE_EXCEPTIONS);
    }

    public static void disableExceptionTrace(boolean bool) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disableExceptionTrace=" + bool);
        }
        if (bool) {
            ((Map)localObjectStore.get()).put(DISABLE_EXCEPTIONS, true);
        } else {
            ((Map)localObjectStore.get()).remove(DISABLE_EXCEPTIONS);
        }
    }

    private void displayExceptionTrace() {
        if (!SdmxException.isDisabledExceptionTrace() && !(this instanceof SdmxNoResultsException)) {
            LOG.error(this.getMessage(), this);
        }
    }

    @Override
    public void printStackTrace() {
        if (!((Map)localObjectStore.get()).containsKey(DISABLE_EXCEPTIONS) && !(this instanceof SdmxNoResultsException)) {
            super.printStackTrace();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(this.getFullMessage());
        }
    }

    public SdmxException(String errorMessage) {
        this(null, null, errorMessage);
    }

    public SdmxException(ExceptionCode code) {
        this(SDMX_ERROR_CODE.INTERNAL_SERVER_ERROR, code, new Object[0]);
    }

    public SdmxException(String errorMessage, SDMX_ERROR_CODE errorCode) {
        this(null, errorCode, errorMessage);
    }

    public SdmxException(Throwable th, String str) {
        this(th, null, str);
    }

    public SdmxException(Throwable th, SDMX_ERROR_CODE errorCode, String message) {
        super(message, th);
        this.th = th;
        if (errorCode != null) {
            this.errorCode = errorCode;
        }
        if (th != null && errorCode == null && th instanceof SdmxException) {
            this.errorCode = ((SdmxException)th).getSdmxErrorCode();
        }
        this.displayExceptionTrace();
    }

    public SdmxException(Throwable th, ExceptionCode code, Object ... args) {
        this(th, null, code, args);
    }

    public SdmxException(SDMX_ERROR_CODE errorCode, ExceptionCode code, Object ... args) {
        this(null, errorCode, code, args);
    }

    public SdmxException(Throwable th, SDMX_ERROR_CODE errorCode, ExceptionCode code, Object ... args) {
        super(th);
        this.th = th;
        this.errorCode = errorCode;
        this.args = args;
        if (th != null && errorCode == null && th instanceof SdmxException) {
            this.errorCode = ((SdmxException)th).getSdmxErrorCode();
        }
        if (code != null) {
            this.code = code;
            this.codeStr = code.getCode();
        }
        this.displayExceptionTrace();
    }

    public SDMX_ERROR_CODE getSdmxErrorCode() {
        if (this.errorCode == null) {
            return SDMX_ERROR_CODE.INTERNAL_SERVER_ERROR;
        }
        return this.errorCode;
    }

    @Override
    public Integer getHttpRestErrorCode() {
        if (this.errorCode == null) {
            return null;
        }
        return this.errorCode.getHttpRestErrorCode();
    }

    @Override
    public String getMessage() {
        if (this.codeStr == null) {
            return super.getMessage();
        }
        return this.getMessage(this.th, this.codeStr, this.args);
    }

    public String getFullMessage() {
        if (this.codeStr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            if (this.getCause() != null) {
                sb.append("  - caused by " + System.lineSeparator());
                if (this.getCause() instanceof SdmxException) {
                    sb.append(((SdmxException)this.getCause()).getFullMessage());
                } else {
                    sb.append(this.getCause().getMessage());
                }
            }
            return sb.toString();
        }
        return this.getFullMessage(this.th, this.codeStr, this.args);
    }

    public String getMessage(Locale loc) {
        return this.getMessage(this.th, this.codeStr, this.args, loc);
    }

    public ExceptionCode getCode() {
        if (this.code == null && this.th != null && this.th instanceof SdmxException) {
            return ((SdmxException)this.th).getCode();
        }
        return this.code;
    }

    public String getMessage(Throwable th, String code, Object[] args) {
        String nestedMessage = "";
        if (code == null) {
            return nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getFullMessage(Throwable th, String code, Object[] args) {
        String nestedMessage = "";
        if (th != null) {
            if (th instanceof SdmxException) {
                SdmxException ex = (SdmxException)th;
                nestedMessage = "Nested Message : " + ex.getFullMessage();
            } else {
                nestedMessage = "Nested Message : " + th.getMessage();
            }
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage.length() > 0) {
            return this.resolveMessage(code, args) + "\n\n" + nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getMessage(Throwable th, String code, Object[] args, Locale loc) {
        String nestedMessage = "";
        if (th != null) {
            nestedMessage = th instanceof SdmxException ? ((SdmxException)th).getMessage(loc) : th.getMessage();
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage != null && nestedMessage.length() > 0) {
            return this.resolveMessage(code, args, loc) + "\n\n" + nestedMessage;
        }
        return this.resolveMessage(code, args, loc);
    }

    public String resolveMessage(String code, Object[] args) {
        if (messageResolver == null) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        Locale myLoc = null;
        myLoc = Locale.ENGLISH;
        sb.append(myLoc);
        sb.append("\n\n");
        String message = messageResolver.resolveMessage(code, myLoc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " the following locales were checked: " + sb.toString();
    }

    public String resolveMessage(String code, Object[] args, Locale loc) {
        if (messageResolver == null) {
            return code;
        }
        String message = messageResolver.resolveMessage(code, loc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " for the following locale " + loc;
    }

    public String getErrorType() {
        return "Sdmx Exception";
    }

    public static void setMessageResolver(MessageResolver messageResolver) {
        SdmxException.messageResolver = messageResolver;
    }

    private static class LocalObjectStore
    extends ThreadLocal<Map<Object, Object>> {
        private LocalObjectStore() {
        }

        @Override
        public Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>();
        }
    }
}

