/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.exception;

import io.sdmx.api.exception.ISdmxException;
import io.sdmx.api.exception.SdmxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorUtil.class);

    public static void rethrow(Throwable th) {
        if (th instanceof SdmxException) {
            throw (SdmxException)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        throw new SdmxException(th, th.getMessage());
    }

    public static String getErrorMessage(Throwable th) {
        if (th.getMessage() == null) {
            if (th.getCause() != null && th.getCause() != th) {
                return ErrorUtil.getErrorMessage(th.getCause());
            }
            if (th instanceof NullPointerException) {
                LOG.error("Null Pointer", th);
                return "Null Pointer Exception";
            }
            return "No Error Message Provided";
        }
        return th.getMessage();
    }

    public static int getHTTPStatusCode(Throwable th) {
        Integer statusCode = 500;
        if (th instanceof ISdmxException) {
            statusCode = ((ISdmxException)((Object)th)).getHttpRestErrorCode();
        }
        if (statusCode == null) {
            return 500;
        }
        return statusCode;
    }
}

