/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.date;

import java.util.HashMap;
import java.util.Map;

public enum TIME_FORMAT {
    YEAR_RANGE("An", "Annual Range", 1L, 31557600000L),
    YEAR("A", "Annual", 1L, 31557600000L),
    HALF_OF_YEAR("S", "Semi-Annual", 2L, 15778800000L),
    THIRD_OF_YEAR("T", "Trimesterly", 3L, 10519200000L),
    QUARTER_OF_YEAR("Q", "Quarterly", 4L, 7889400000L),
    MONTH("M", "Monthly", 12L, 2629800000L),
    WEEK("W", "Weekly", 52L, 604800000L),
    DATE("D", "Daily", 356L, 86400000L),
    HOUR("H", "Hourly", 8766L, 3600000L),
    DATE_TIME("I", "Date Time", 31557600000L, 1L);

    private static Map<String, TIME_FORMAT> timeFormatMap;
    private String frequencyCode;
    private String readableCode;
    private long periodsPerYear;
    private long millisInPeriod;
    private static boolean alternateHalfYear;

    public static void setUseAlternateHalfYear(boolean val) {
        alternateHalfYear = val;
    }

    private TIME_FORMAT(String frequencyCode, String readableCode, long periodsPerYear, long millisInPeriod) {
        this.frequencyCode = frequencyCode;
        this.readableCode = readableCode;
        this.periodsPerYear = periodsPerYear;
        this.millisInPeriod = millisInPeriod;
    }

    public String getReadableCode() {
        return this.readableCode;
    }

    public long getPeriodsInAYear() {
        return this.periodsPerYear;
    }

    public long getMillisInPeriod() {
        return this.millisInPeriod;
    }

    public String getFrequencyCodeId() {
        if (this.equals((Object)HALF_OF_YEAR) && alternateHalfYear) {
            return "H";
        }
        return this.frequencyCode;
    }

    public static TIME_FORMAT getTimeFormatFromCodeId(String codeId) {
        TIME_FORMAT tf;
        if (timeFormatMap == null) {
            HashMap<String, TIME_FORMAT> newMap = new HashMap<String, TIME_FORMAT>();
            for (TIME_FORMAT format : TIME_FORMAT.values()) {
                newMap.put(format.getFrequencyCodeId(), format);
            }
            if (alternateHalfYear) {
                newMap.put("H", HALF_OF_YEAR);
            }
            timeFormatMap = newMap;
        }
        if ((tf = timeFormatMap.get(codeId)) != null) {
            return tf;
        }
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (TIME_FORMAT currentTimeFormat : TIME_FORMAT.values()) {
            sb.append(concat + currentTimeFormat.getFrequencyCodeId());
            concat = ",";
        }
        throw new IllegalArgumentException("Frequency : " + codeId + " is not supported. Allowed values for frequency are : " + sb.toString());
    }

    public static boolean isValidCodeId(String codeId) {
        for (TIME_FORMAT tf : TIME_FORMAT.values()) {
            if (!tf.getFrequencyCodeId().equals(codeId)) continue;
            return true;
        }
        return false;
    }
}

