/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.date;

import io.sdmx.api.date.PERIOD_OVERLAP;
import io.sdmx.api.date.SdmxDate;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

public interface SdmxPeriod
extends Comparable<SdmxPeriod>,
Serializable {
    default public String toISOString() {
        if (this.isAllPeriods()) {
            return "AllPeriods";
        }
        if (this.hasStartPeriod() && this.hasEndPeriod()) {
            return this.getStartPeriod().getDateInSdmxFormat() + "/" + this.getEndPeriod().getDateInSdmxFormat();
        }
        if (this.hasStartPeriod()) {
            return this.getStartPeriod().getDateInSdmxFormat() + "/";
        }
        if (this.hasEndPeriod()) {
            return "/" + this.getEndPeriod().getDateInSdmxFormat();
        }
        return "AllPeriods";
    }

    public PERIOD_OVERLAP getOverlap(SdmxPeriod var1);

    public Set<SdmxPeriod> split(SdmxPeriod var1);

    public boolean isAllPeriods();

    public SdmxDate getStartPeriod();

    public SdmxDate getEndPeriod();

    public boolean hasStartPeriod();

    public boolean hasEndPeriod();

    public boolean isBeforeStartPeriod(Date var1);

    public boolean isAfterEndPeriod(Date var1);

    public boolean isInPeriod(Date var1);

    public boolean isInPeriod(Date var1, Date var2);

    public boolean isInPeriod(SdmxPeriod var1);

    public boolean isStartEqual(SdmxPeriod var1);

    public boolean isBeforePeriod(SdmxPeriod var1);

    public boolean isEndEqual(SdmxPeriod var1);

    public boolean isAfterPeriod(SdmxPeriod var1);

    public boolean isFullyInPeriod(SdmxPeriod var1);
}

