/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.api.csv;

import io.sdmx.api.exception.SdmxException;

public enum DELIMITER {
    COMMA(',', "comma"),
    TAB('\t', "tab"),
    SEMICOLON(';', "semicolon"),
    SPACE(' ', "space");

    private char delimiter;
    private String asString;

    private DELIMITER(char delimiter, String asString) {
        this.delimiter = delimiter;
        this.asString = asString;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getDelimiterAsString() {
        return this.asString;
    }

    public static DELIMITER parseDelimiter(char delim) {
        for (DELIMITER delimiter : DELIMITER.values()) {
            if (delimiter.delimiter != delim) continue;
            return delimiter;
        }
        throw new SdmxException("Could not resolve delimiter '" + delim + "'");
    }

    public static DELIMITER parseDelimiter(String str) {
        if (str == null) {
            return COMMA;
        }
        for (DELIMITER delimiter : DELIMITER.values()) {
            if (delimiter.asString.equals(str)) {
                return delimiter;
            }
            if (str.length() != 1 || delimiter.delimiter != str.charAt(0)) continue;
            return delimiter;
        }
        throw new SdmxException("Could not resolve delimiter '" + str + "'");
    }
}

